*A lot of the documentation below existed in asset.do before the April 2008 updating (which is what this version is).;
*To make things clearer, all comments added in 4-08 are prefaced with "408C" (for "April 2008 Comment");
/*things that might be causing the problem - most insurance variables */
/* are coded as 0 if they say they don't have insurance (case 5) and  */
/* if they say they don't know whether they have insurance (case 8).  */
/* You can see if changing that code makes a difference. I added      */
/* another variable for wave3 - insnot3, set to 1 if they weren't     */
/*covered for insurance, and 0 if they were. I didn't have time to look at wave 5. */

set more 1

#delimit ;  
set more 1;  
*global folder "\\econ-san-fs\Home4\uctpkp0\SystemFolder\Windows7\Desktop";
*global folder "C:\Users\Jeremy\Dropbox";
*global folder "~/";
*global folder "\\ad.ucl.ac.uk\homer\zctpmer\downloads";
global folder "D:\Dropbox\";
* set this to 1 if include 2020 wave;
global INCLUDE2020 1;


         local saved  "$folder\hrs\merge\";
         local trackd "$folder\hrs\tracker\";
         local wave1d "$folder\hrs\wave1\";
         local wave2d "$folder\hrs\wave2\";
         local wave3d "$folder\hrs\wave3\";
         local wave4d "$folder\hrs\wave4\";
         local wave5d "$folder\hrs\wave5\";
		 local wave6d "$folder\hrs\wave6\";
         local wave7d "$folder\hrs\wave7\";
         local wave8d "$folder\hrs\wave8\";
		 local wave9d "$folder\hrs\wave9\";
		 local wave10d "$folder\hrs\wave10\";
		 local wave11d "$folder\hrs\wave11\";
		 local wave12d "$folder\hrs\wave12\";
		 local wave13d "$folder\hrs\wave13\";
		 local wave14d "$folder\hrs\wave14\";
		 local wave15d "$folder\hrs\wave15\";
         local aheadw1 "$folder\hrs\aheadw1\";
         local aheadw2 "$folder\hrs\aheadw2\";


*log using `saved'insure.log, replace; 

* do insurance;
* these are mostly 0-1 variables, =1 if yes;
**************************************************;
* here are the variables and what they should mean;
* insgov=1 if the individual has insurance provided by VA/CHAMPUS, postal workers;
* insgov=2 if Medicaid insurance;
* medcare=1 if the individual draws Medicare;
* epins=1 if you get insurance through an employer;
* eprhi=1 if you get retiree health insurance through YOUR (not spouses) employer or union;
* inssp=1 if you get insurance through your spouses insurance;
* epfr=1 if insurance if free or reduced cost (at some time in the future I would like it to be =1 if reduced cost, =2 if free;
* epsp=1 if your plan covers your spouse ;
* eprsp=1 if your spouse gets insurance when you retire (is this a sensible variable? what happens if your spouse has his\her own health insurance plan?);
* eprfr=1 if employer or union provides you with retiree coverage, and if it is free (or reduced cost);
* inspriv=1 if you get health insurance privately;

* QUESTION For SELF: should it =1 if YOUR union or employer provides coverage?; 
******************* WAVE I *******************************************; clear;
set mem 300m;
*use `wave1d'househld; 
* Note: the "`wave1d'househld.dta" file used here is compatible with
the code-book, that is, it is not re-coded by some .do file. Please note that
some househld.dta file is re-coded when you use househld.do file from HRS web to 
generate it.;
*408C: To satisfy the condition above, I created the file non_recoded_househld.dta, which differs from the "househld.dta" file that uses a .do file with recoding;
use `wave1d'non_recoded_househld; 

* medicare ? ;
gen medcare1=0;
*408C: needed to change v6603 to V6603 (capitalized);
replace medcare1=1 if V6603==1;
replace medcare1=. if (V6602==9|V6602==.|V6603==9);

* government provided insurance?;
gen insgov1=.;
replace insgov1=0 if V6602==5|V6602==8; * "No" and "DK" case for V6602;

* note on coding convention: "Dk" is assumed to be the same as "NO". We believe this assumption is close to reality since in 
most cases if people don't know about somthing it may have never happened; 

replace insgov1=1 if V6602==1; * 1= "having government provided insurance"; * "VA/CHAMPUS" and "other";
replace insgov1=0 if V6603==1 & V6604~=1 & V6605~=1; * not counting Medcare as government provided insurance;

replace insgov1=2 if V6604==1;
 *employer provided health insurance?; 
gen epins1=.;
replace epins1=1 if V6614==1|V6614==2|V6614==4; * " yes", "covered only when working" and "covered in the near future"; 
replace epins1=0 if V6614==5|V6614==8; * "no" and "DK" cases; 

*insurance through your firm? (as opposed to spouses firm);
gen insspa1=.; 
* Li's question??? : what is the value if people don't get insurance from employers;
* NOTE: I set it as 0 for all similar variables in the following;

replace insspa1=0 if V6614==5|V6614==8; * cases where people don't have insurance from employers;
replace insspa1=0 if V6616==1|V6616==2; * own employer/union; 
replace insspa1=1 if V6616==3|V6616==4|V6616==7; * "spouse's employer" , "spouse's union" , and "other: ex spouse and deceased spouse";

gen insspb1=.; 
replace insspb1=0 if V6614==5|V6614==8; * cases where people don't have insurance from employers;
replace insspb1=0 if V6615==1; * cases where people have only one insurance plan from employers;
replace insspb1=0 if V6624==1|V6624==2; * own employer/union;
replace insspb1=1 if V6624==3|V6624==4|V6624==7; * "spouse's employer" , "spouse's union" , and "other: ex spouse and deceased spouse";

* is the health insurance free (or reduced cost)?;
gen epfra1=.;
replace epfra1=0 if V6614==5|V6614==8; * Cases people don't get insurance from employers;
replace epfra1=0 if V6617==1;
replace epfra1=1 if V6617==2|V6617==3;
gen epfrb1=.;
replace epfrb1=0 if V6614==5|V6614==8; * Cases where people don't get insurance from employers;
replace epfrb1=0 if V6615==1; * cases where people have only one insurance plan from employers;
replace epfrb1=0 if V6625==1;
replace epfrb1=1 if V6625==2|V6625==3;

* does employer provide retiree health insurance?;
gen eprhia1=.;
replace eprhia1=0 if V6614==5|V6614==8; * cases where people don't get insurance from employers;
replace eprhia1=0 if V6618==8; * here "DK" is assumed to mean that "Nothing like 
this has happened";
replace eprhia1=0 if V6618==5 & (V6619==5|V6619==8); * Here "DK" is assumed to 
be the same as "NO" for V6619;
replace eprhia1=1 if V6618==1|V6619==1;
replace eprhia1=0 if insspa1==1; * eprhi=1 only if it is insurance through your employer;
gen eprhib1=.;
replace eprhib1=0 if V6614==5|V6614==8; * cases where people don't get insurance from employers;
replace eprhib1=0 if V6615==1; * cases where people have only one insurance plan;
replace eprhib1=0 if V6626==8; * "Dk" is assumed to mean that "Nothing like this 
has happened";
replace eprhib1=0 if V6626==5 & (V6627==5|V6627==8); * Here "DK" is assumed to 
be the same as "No" for V6627;
replace eprhib1=1 if V6626==1|V6627==1; 
replace eprhib1=0 if insspb1==1; * eprhi=1 only if it is insurance through your employer;
* Note: One problem may be or may not be relevant here: If these two insurance plans come from the same organization,
employer or union, then eprhia1=eprhib1, although the person may can only have one insurance plan after his/her retirement;

* is the eprhi free (or reduced cost)?;
gen eprfra1=.;
replace eprfra1=0 if V6614==5|V6614==8; * cases where people don't get insurance from employers;
replace eprfra1=0 if (V6618~=1 & V6619~=1); * cases where employers don't provide retiree insurance;
replace eprfra1=1 if V6620==1|V6620==3;
replace eprfra1=0 if V6620==5;
* note that there are too many "DK" for V6620, so there are too many missing 
values for eprfra1; * 360 "DK" cases;
gen eprfrb1=.;
replace eprfrb1=0 if V6614==5|V6614==8; * cases where people don't get insurance from employers;
replace eprfrb1=0 if V6615==1; * cases where people have only one insurance from employers;
replace eprfrb1=0 if (V6626~=1 & V6627~=1); * cases where employers don't provide retiree insurance;
replace eprfrb1=1 if V6628==1|V6628==3;
replace eprfrb1=0 if V6628==5; * "DK" is not the same as "No".;
* note that there are many "DK" causing missing values;

* will the spouse be covered by retiree insurance?;
gen eprspa1=.;
replace eprspa1=0 if V6614==5|V6614==8; * cases where people don't get insurance from employers;
replace eprspa1=0 if (V6618~=1 & V6619~=1); * cases where employers don't provide retiree insurance;
replace eprspa1=0 if V6622==5; * "DK" is not assumed to be the same as "no";
replace eprspa1=1 if V6622==1;
* Note that there are too many "DK" causing too many missing values;
* about 320 "DK" for V6622; 
replace eprspa1=0 if insspa1==1; * eprsp=1 only if it is insurance through your employer;
gen eprspb1=.;
replace eprspb1=0 if V6614==5|V6614==8; * cases where people don't get insurance from employers;
replace eprspb1=0 if V6615==1; * cases where people have only one insurance from employers;
replace eprspb1=0 if (V6626~=1 & V6627~=1); * cases where employers don't provide retiree insurances;
replace eprspb1=0 if V6630==5; * "DK" is not assumed to be the same as "no";
replace eprspb1=1 if V6630==1;
* note that there are too many "DK" causing too many missing values;

replace eprspb1=0 if insspb1==1; * eprsp=1 only if it is insurance through your employer;

* do you have private insurance?;
gen inspriv1=0;
replace inspriv1=0 if V6632==5;
replace inspriv1=1 if V6632==1;
gen insexch1=0;

* variables for whether people will loose health insurance after they leave their jobs;
* Li's question????: I don't understand what is meant by this variable.
  If this variable means whether people will lose health insurance from their employers after 
they leave their job, then the following re-coding is correct.
  If this variable means whether people will lose health insurance from both their employers and their
spouses' employers, then the folloing re-coding is not correct;

gen eprhi1=eprhia1;
summ eprhi1; 
tab eprhi1;
count if eprhib1~=. & (eprhia1==0|eprhia1==.);
replace eprhi1=eprhib1 if eprhib1~=. & (eprhia1==0|eprhia1==.);
summ eprhi1;

*408C:testing section;
*tab eprhi1;
*gen B_AVAILABLE=.;
*replace B_AVAILABLE=1 if eprhib1!=.;
*rename APN_FIN PN;
*gen temp=real(HHID);
*drop HHID;
*gen HHID=temp;
*drop temp;
*gen temp=real(PN);
*drop PN;
*gen PN=temp;
*drop temp;
*sort HHID PN;
*keep HHID PN B_AVAILABLE;
*save O:\USER_LIB\g1kmb03\for_eric\junk_for_comparing\insure_compare.dta;


gen epfr1=.;
replace epfr1=1 if epfra1==1|epfrb1==1; 
* replace epfr1=0 if epfr1~=1 & epfra1==0; * This statement will convert "TRUE" missing values into 0 values;
replace epfr1=0 if epfra1==0 & epfrb1==0;
gen eprfr1=.;
replace eprfr1=1 if eprfra1==1|eprfrb1==1;
* replace eprfr1=0 if eprfr1~=1 & eprfra1==0; * This statement will convert "TRUE" missing values into 0 values;
replace eprfr1=0 if eprfra1==0 & epfrb1==0;
gen eprsp1=.;
replace eprsp1=1 if eprspa1==1|eprspb1==1;
* replace eprsp1=0 if eprsp1~=1 & eprspa1==0; * This statement will convert "TRUE" missing values into 0 values;
replace eprsp1=0 if eprspa1==0 & eprspb1==0;
gen inssp1=.;
replace inssp1=1 if insspa1==1|insspb1==1;
* replace inssp1=0 if insspa1==0 & insspb1~=1; * This statement will convert "TRUE" missing values into 0 values;
replace inssp1=0 if insspa1==0 & insspb1==0;

************************************************************************;
* here is a wave 1 quirk.  househld.dta is a household level file.  only;
* the "financially knowledgeable" member of the reports insurance. The  ;
* "financially knowledgable" repsondent also reports for the spouse     ;
* These spousal reports are described below ****************************;  

* medicare ? ;
gen s_medcare1=0;
replace s_medcare1=1 if V6803==1;


* government provided insurance?;

gen s_insgov1=.;
replace s_insgov1=0 if V6802==5|V6802==8; * "No" and "DK" case for V6602;

replace s_insgov1=1 if V6802==1; * 1= "having government provided insurance"; 
* "VA/CHAMPUS" and "other";
replace s_insgov1=0 if V6803==1 & V6804~=1 & V6805~=1; * not counting Medcare as government provided insurance;

replace s_insgov=2 if V6804==1; * Medicaid;


gen spousea=0;
replace spousea=1 if V6807==1 & V6808==1 & (V6809==1|V6810==1|V6812==1);
gen spouseb=0;
replace spouseb=1 if V6807==1 & V6808==1 & (V6811==1|V6812==1);

*employer provided health insurance?; 
gen s_epins1=0;
replace s_epins1=1 if V6807==1 & V6808==1;
replace s_epins1=1 if V6814==1|V6814==2|V6814==4;;

*insurance through your firm? (as opposed to spouses firm);
gen s_insspa1=0; 
replace s_insspa1=1 if epins1==1 & spousea==1 & insspa1==0;
gen s_insspb1=0; 
replace s_insspb1=1 if epins1==1 & spouseb==1 & insspb1==0;
gen s_insspc1=0;
replace s_insspc1=1 if V6816==1|V6816==2; *R="spouse's spouse", provider of insurance; 
gen s_insspd1=0;
replace s_insspd1=1 if V6824==1|V6824==2;

* is the health insurance free (or reduced cost)?;
gen s_epfra1=0;
replace s_epfra1=1 if epfra1==1 & spousea==1; 
gen s_epfrb1=0;
replace s_epfrb1=1 if epfrb1==1 & spouseb==1;
gen s_epfrc1=0;
replace s_epfrc1=1 if V6817==2|V6817==3;
gen s_epfrd1=0;
replace s_epfrd1=1 if V6825==2|V6825==3;

* does employer provide retiree health insurance?;
gen s_eprhia1=0;
replace s_eprhia1=1 if V6618==1|V6619==1;
replace s_eprhia1=0 if insspa1~=1; * it is only eprhi if the insurance is provided through YOUR employer;
gen s_eprhib1=0; replace s_eprhib1=1 if V6626==1|V6627==1; 

replace s_eprhib1=0 if insspa1~=1; * it is only eprhi if the insurance is provided through YOUR employer;
gen s_eprhic1=0;
replace s_eprhic1=1 if V6818==1|V6819==1;
replace s_eprhic1=0 if s_insspc1==1;
gen s_eprhid1=0;
replace s_eprhid1=1 if V6826==1|V6827==1;
replace s_eprhid1=0 if s_insspd1==1;

* is the eprhi free (or reduced cost)?;
gen s_eprfra1=0;
replace s_eprfra1=1 if eprspa1==1 & spousea==1;
gen s_eprfrb1=0;
replace s_eprfrb1=1 if eprspb1==1 & spouseb==1;
gen s_eprfrc1=0;
replace s_eprfrc1=1 if V6820==1|V6620==2;
gen s_eprfrd1=0;
replace s_eprfrd1=1 if V6828==1|V6628==2;

* will the spouse be covered by retiree insurance?;
gen s_eprspa1=0; 
replace s_eprspa1=1 if (V6618==1|V6619==1) & insspa1==1 & spousea==1;
gen s_eprspb1=0;
replace s_eprspb1=1 if (V6626==1|V6627==1) & insspb1==1 & spousea==1;
gen s_eprspc1=0;
replace s_eprspc1=1 if V6822==1;
gen s_eprspd1=0;
replace s_eprspd1=1 if V6630==1;

* do you have private insurance?;
gen s_inspriv1=.;
gen s_insexch1=0;
replace s_inspriv1=0 if V6832==5|V6832==.|V6832==0;
replace s_inspriv1=1 if V6832==1|V6832==3;

gen s_eprhi1=s_eprhia1;
summ s_eprhi1;
replace s_eprhi1=s_eprhib1 if s_eprhib1~=. & s_eprhia1==0;
summ s_eprhi1;
replace s_eprhi1=s_eprhic1 if s_eprhic1~=. & s_eprhi1==0;
summ s_eprhi1;
replace s_eprhi1=s_eprhid1 if s_eprhid1~=. & s_eprhi1==0;
summ s_eprhi1;
gen s_epfr1=.;
replace s_epfr1=1 if s_epfra1==1|s_epfrb1==1|s_epfrc1==1|s_epfrd1==1; 
replace s_epfr1=0 if s_epfra1==0 & s_epfrb1==0 & s_epfrc1==0 & s_epfrd1==0;
gen s_eprfr1=0;
replace s_eprfr1=1 if s_eprfra1==1|s_eprfrb1==1|s_eprfrc1==1|s_eprfrd1==1;
gen s_eprsp1=0;
replace s_eprsp1=1 if s_eprspa1==1|s_eprspb1==1|s_eprspa1==1|s_eprspb1==1;
gen s_inssp1=0;
replace s_inssp1=1 if s_insspa1==1|s_insspb1==1;

replace s_medcare1=. if V6801~=1;
replace s_epins1=. if V6801~=1;
replace s_inssp1=. if V6801~=1;
replace s_epfr1=. if V6801~=1;
replace s_eprfr1=. if V6801~=1;
replace s_eprsp1=. if V6801~=1;
replace s_eprhi1=. if V6801~=1;
replace s_inspriv1=. if V6801~=1;
*408C: renamed APN_FIN ("1992 Financial Resp Person Number") as PN, because the new version of househld doesn't contain PN;
rename APN_FIN PN;
keep HHID PN s_* ins* ep* medc* ;

summ;

keep HHID PN s_* ins* ep* medc*;  
sort HHID PN;
save `saved'insure, replace;
drop _all;

****************************** WAVE II *************************************;
clear;
set mem 300m;
use `wave2d'w2r;

summ HHID;

*gen HHIDPN=1000*HHID+PN;
sort HHID PN;
merge HHID PN using `saved'insure;
drop _merge;
* medicare ? ;
gen medcare2=0;
replace medcare2=1 if W6701==1|W6702==1|W6703==1|W6704==1;

* does the govt provide insurance for you?;
gen insgov2=.;
replace insgov2=0 if W6700==5|W6700==8; * "DK" is assumed to be the same as "NO";
replace insgov2=1 if (W6701>2 & W6701<98)|(W6702>2 & W6702<98)|(W6703>2 & W6703<98); *1=yes; * exlude "medcare", "medcaid" and "DK", "RF"; 
* "INAP" for W6704 for all observations;
* replace insgov2=0 if insgov2==1 & (W6701<3 | W6701>97) & (W6702<3 | W6702>97); 
* the above statement is self-contradictory one;
replace insgov2=0 if W6701==1|W6702==1|W6703==1; * no "1" for W6704;
replace insgov2=2 if W6701==2|W6702==2; * no "2" for any W6703 or W6704; 

gen same=0; *dummy var for whether the insurance plan is the same as last
interview;
* impute "same" variable;
replace same=1 if W6705==1|W6707==1|W6708==1|W6709==1;
gen inssame2=same;
tab same;
list same in 1/10;

gen epins2=.;
gen insspa2=.; 
gen insspb2=.; 
gen epfra2=.;
gen epfrb2=.;
gen eprhia2=.;
gen eprhib2=.;
gen eprfra2=.;
gen eprfrb2=.;
gen eprspa2=.;
gen eprspb2=.;

*************************************************************;
* encode as below if the respondent stayed with the same plan;
*************************************************************;
* note: as you can see from the experiments below, there are too many
observations for which wave1 values are missing. This causes a lot of missing
values for wave2. There are about 2,000 missing values.  This is caused by the ; 

* does employer provide health insurance?;
replace epins2=epins1 if same==1;

* experiment;
gen flagw2=0;
replace flagw2=1 if epins1==. & same==1;

*insurance through own firm (as opposed to spouses firm?);
replace insspa2=insspa1 if same==1; 
replace insspb2=insspb1 if same==1; 

* is the insurance free (or reduced cost)?;
replace epfra2=epfra1 if same==1;
replace epfrb2=epfrb1 if same==1;

* employer provided retiree health insurance;
replace eprhia2=eprhia1 if same==1;
replace eprhib2=eprhib1 if same==1;

* is the eprhi free?;
replace eprfra2=eprfra1 if same==1;
replace eprfrb2=eprfrb1 if same==1;

* will the spouse be covered? ;
replace eprspa2=eprspa1 if same==1;
replace eprspb2=eprspb1 if same==1;


**************************************************;
* encode as below if the individual switched plans;
**************************************************;

* does employer provide health insurance?;
replace epins2=0 if (W6724==5|W6724==8) & same==0; * "same==0" is unnecessary here;
replace epins2=1 if W6724==1 & same==0;

*insurance through spouse's firm (as opposed to own firm?);
replace insspa2=0 if (W6726==1|W6726==2|W6726==3) & same==0; * own;
replace insspa2=1 if (W6726==4|W6726==5|W6726==6) & same==0; * spouse;
replace insspb2=0 if (W6740==1|W6740==2|W6740==3) & same==0; * own;
replace insspb2=1 if (W6740==4|W6740==5|W6740==6) & same==0; * spouse;
* Li's question????: How about those "through own business", "employer or union of ex-spouse or deceased spouse",
   "purchased through own business/self-employment", "through pension/retirement system/association, "through group coverage, 
e.g, professional, farmers, AARP, etc.", "Through welfare/social services/umemployment", 
"through medicaid/medicare/social security;

* Li's question????: please deactivate the following statements if you decide to;

replace insspa2=0 if W6726==7; * "through own business";
replace insspa2=0 if W6726==11; * "Employer or union of ex-spouse or deceased spouse";
replace insspa2=0 if W6726==13; * "purchased through own business/self-employment";
replace insspa2=0 if W6726==14; * "Through pension/retirement system/association";
replace insspa2=0 if W6726==15; * "Through group coverage, e.g, professional farmers, AARP, etc.";
replace insspa2=0 if W6726==16; * "through welfare/social services/unemployment";
replace insspa2=0 if W6726==17; * "through medicaid/medicare/social security";
replace insspa2=0 if W6726==90; * "not text displayed";

replace insspb2=0 if W6740==7; * "through own business";
replace insspb2=0 if W6740==11; * "Employer or union of ex-spouse or deceased spouse";
replace insspb2=0 if W6740==13; * "purchased through own business/self-employment";
replace insspb2=0 if W6740==14; * "Through pension/retirement system/association";
replace insspb2=0 if W6740==15; * "Through group coverage, e.g, professional farmers, AARP, etc.";
replace insspb2=0 if W6740==16; * "through welfare/social services/unemployment";
replace insspb2=0 if W6740==17; * "through medicaid/medicare/social security";
replace insspb2=0 if W6740==90; * "not text displayed";

replace insspb2=0 if W6725==1; * the case where there is only one emplyer-provided insurance;


  

* is the insurance free?;
replace epfra2=0 if W6733==1 & same==0; *no;
* Li's question???: how about "paid by Medicare/welfare/public assistance/other to be moved/recoded elsewhere";
* Li's question????:please deactivate any of  the following two statements if you would like;
replace epfra2=0 if W6733==5 & same==0; * "paid by Medicare/welfare/public assistance/other to be moved/recoded elsewhere";
replace epfra2=0 if W6733==7 & same==0; * "paid other(specify)", no such case here;
replace epfra2=1 if (W6733==2|W6733==3) & same==0;*yes;
replace epfrb2=0 if W6747==1 & same==0;
* Li's question???: how about "paid by Medicare/welfare/public assistance/other to be moved/recoded elsewhere";
* Li's question????:please deactivate any of  the following two statements if you would like;
replace epfrb2=0 if W6747==5 & same==0; * "paid by Medicare/welfare/public assistance/other to be moved/recoded elsewhere";
replace epfrb2=0 if W6747==7 & same==0; * "paid other(specify)", 2 such cases;
replace epfrb2=1 if (W6747==2|W6747==3) & same==0;
replace epfrb2=0 if W6725==1; * the case where there is only one employer-provided insurance;


* does employer provide retiree health insurance;
tab eprhia2;
replace eprhia2=0 if (W6734==5 & W6735==5) & same==0;* 1=yes;
tab eprhia2;
replace eprhia2=1 if (W6734==1|W6735==1) & same==0;* 1=yes;
tab eprhia2;
replace eprhib2=0 if (W6748==5 & W6749==5) & same==0; 
replace eprhib2=1 if (W6748==1|W6749==1) & same==0; 
replace eprhib2=0 if W6725==1 & same==0; * the case where there is only one employer-provided insurance;


* is the eprhi free (or at reduced cost)?;
replace eprfra2=0 if W6736==5 & same==0; * nope;
replace eprfra2=1 if (W6736==1|W6733==3) & same==0; *yup;
replace eprfrb2=0 if W6750==5 & same==0;
replace eprfrb2=1 if (W6750==1|W6750==3) & same==0;
replace eprfrb2=0 if W6725==1; * the case where there is only one employer-provided insurance;


* will the spouse be covered after retirement?;
replace eprspa2=0 if W6738==5 & same==0; * here "DK" is not assumed to be the same as "NO" since this is about the future;
replace eprspa2=1 if W6738==1 & same==0;
replace eprspb2=0 if W6752==5 & same==0;
replace eprspb2=1 if W6752==1 & same==0;
replace eprspb2=0 if W6725==1; * the case where there is only one employer-provided insurance;

gen inspriv2=0; * insurance purchased directly from an insurance company; 
gen insexch2=0;
replace inspriv2=0 if W6754==5|W6754==8; * This is about "basic" insurance purchased directly.;
replace inspriv2=1 if W6754==1; * This is about "basic insurance purchased
directly";
* no information about "INAP" cases;

replace inspriv2=1 if W6757==1; * This is about "any supplementary health insurance coverage";
replace inspriv2=0 if (W6757==5|W6757==8) & (W6754==5|W6754==8); * the same as above;
 
* Li's suggesttion: The initial wording is misleading since it is 
"variables for whether people will loose their health insurance after they leave their jobs",
 I think we should change it to "variables for whether people can "keep" their health insurance after they leave their jobs";

gen eprhi2=eprhia2; 
tab eprhi2;
replace eprhi2=eprhib2 if eprhib2~=. & eprhia2==0;
tab eprhi2;
replace eprhi2=0 if insspa2==1|insspb2==1; * the case where covered by insurance from spouse's employer or union;
tab eprhi2;
replace eprhi2=1 if insspa2==1 & eprspa2==1; * The case where the respondent is covered by insurance from spouse's employer
or union and such organization give insurance to employees' spouses after retirement; 
tab eprhi2;
replace eprhi2=1 if insspb2==1 & eprspb2==1; * The case where the respondent is covered by insurance from spouse's employer
or union and such organization give insurance to employees' spouses after retirement;   
tab eprhi2;
replace eprhi2=0 if epins2==0; * no employer-provided insurance;
tab eprhi2;

* no employer-provided health insurance; 
replace epfra2=0 if epins2==0;
tab eprhia2;
replace eprhia2=0 if epins2==0;
tab eprhia2;
replace eprfra2=0 if epins2==0;
replace eprspa2=0 if epins2==0;
replace epfrb2=0 if epins2==0;
replace eprhib2=0 if epins2==0;
replace eprfrb2=0 if epins2==0;
replace eprspb2=0 if epins2==0;

gen epfr2=.;
replace epfr2=1 if epfra2==1|epfrb2==1;
replace epfr2=0 if epfra2==0 & epfrb2==0;
replace epfr2=0 if epins2==0;
gen eprfr2=.;
replace eprfr2=1 if eprfra2==1|eprfrb2==1;
replace eprfr2=0 if eprfra2==0 & eprfrb2==0;
replace eprfr2=0 if epins2==0;
gen eprsp2=.;
replace eprsp2=1 if eprspa2==1|eprspb2==1;
replace eprsp2=0 if eprspa2==0 & eprspb2==0;
replace eprsp2=0 if epins2==0;
gen inssp2=.;
replace inssp2=1 if insspa2==1|insspb2==1;
replace inssp2=0 if insspa2==0 & insspb2==0;
replace inssp2=0 if epins2==0;
keep HHID PN s_* ins* ep* medc*;
*408C: Needed to change HHID and PN from string to real in new data;
gen temp=real(HHID);
drop HHID;
gen HHID=temp;
drop temp;
gen temp=real(PN);
drop PN;
gen PN=temp;
drop temp;
sort HHID PN;
save `saved'insure, replace;
drop _all;

************************ WAVE III *******************************;
use `wave3d'h96r_r; * note that "`wave3d'w3r" may not be compatible with code-book; 
gen temp=real(HHID);
drop HHID;
gen HHID=temp;
drop temp;
gen temp=real(PN);
drop PN;
gen PN=temp;
drop temp;

* medicare ? ;
gen medcare3=0;
replace medcare3=1 if E5133==1; * this one also asks about Medicare part B, which I did not code;

* government-provided insurance;
gen insgov3=.;
replace insgov3=1 if E5145==1;
replace insgov3=0 if E5145==5|E5145==8;
replace insgov3=2 if E5135==1|E5136==1|E5138==1|E5139==1|E5142==1|E5143==1|E5144==5;

* gen epspa3=.; * note that it was retiree spousal health insurance for waves 1 and 2, whereas it is just spousal health insurance in waves 3 and 4;

* employer provided health insurance?; 
gen epins3=.;
replace epins3=1 if E5160==1; 
replace epins3=0 if E5160==5|E5160==8;
*replace epins3=0 if E5158==1; * self-employed; 
* note that: according to code-book, we may use E5158. But I treat people self-employed as having no employer; 

* replace epins3=0 if epins3==. & (E5133==1|E5136==1|E5145==1); * not correct re-coding;

*insurance through your spouse's firm/union? (as opposed to your own firm);
gen insspa3=.;
replace insspa3=0 if E5163_1==1|E5163_1==2|E5163_1==3; * own employer/union;
replace insspa3=1 if E5163_1==4|E5163_1==5|E5163_1==6; * spouses;
replace insspa3=0 if E5163_1==7; * get insurance from someplace else;
replace insspa3=0 if E5160==5|E5160==8; * no employer-provided insurance;
replace insspa3=0 if E5157==1; * self-employed;
replace insspa3=0 if epins3==0; * may be unnecessary; * no employer-provided
insurance;
gen insspb3=.;
replace insspb3=0 if E5163_2==1|E5163_2==2|E5163_2==3; * own employer/union;
replace insspb3=1 if E5163_2==4|E5163_2==5|E5163_2==6; * spouses;
replace insspb3=0 if E5163_2==7; * get insurance from someplace else;
replace insspb3=0 if E5161==1; * only one employer-provided insurance;
replace insspb3=0 if E5160==5|E5160==8; * "no employer-provided insurance"; 
replace insspb3=0 if E5157==1; * sely-employed;
replace insspb3=0 if epins3==0; * no employer-provide inusrance; * may be unnecessary;

* is the health insurance is free (or reduced cost)?;
gen epfra3=.;
replace epfra3=1 if E5166_1==2|E5166_1==3;
replace epfra3=0 if E5166_1==1;
* 2 "other" and 32 "DK" cases are treated as missing;
replace epfra3=0 if E5165_1==1; * obtain insurance from spouse;
replace epfra3=0 if E5160==5|E5160==8; * No employer-provided insurance;
replace epfra3=0 if E5157==1; * self-employed;
replace epfra3=0 if epins3==0; * no employer-provided insurance; * may be 
unnecessary;

gen epfrb3=.; 
replace epfrb3=1 if E5166_2==2|E5166_2==3;
replace epfrb3=0 if E5166_2==1;
replace epfrb3=0 if E5165_2==1; * obtain insurance from the spouse;
replace epfrb3=0 if E5161==1; * only one employer-provided insurance;
replace epfrb3=0 if E5160==5|E5160==8; * no employer-provided insurance;
replace epfrb3=0 if E5157==1; * self-employed;
replace epfrb3=0 if epins3==0; * no employer-provided insurance; * may not be 
necessary;

* does employer provide retiree health insurance;
gen eprhia3=.;
replace eprhia3=0 if E5191_1==5|E5191_1==8;
replace eprhia3=0 if E5160==5|E5160==8|E5184_1==2|E5190_1==1|E5165_1==1|E5184_1==1|
E5190_1==3; * "INAP" cases; * no information about E5162, which may cause some 
Unjustified values, but that is the best we can do;
replace eprhia3=1 if E5191_1==1|E5193_1==1|E5194_1==1|E5200_1==1; 
replace eprhia3=0 if epins3==0; * no employer-provided insurance;
replace eprhia3=0 if insspa3==1;
gen eprhib3=.;
replace eprhib3=0 if E5194_2==5|E5191_2==8;
replace eprhib3=0 if E5160==5|E5160==8|E5184_2==2|E5190_2==1|E5165_2==1|
E5184_2==1|E5190_2==3; * true "INAP" cases;
replace eprhib3=1 if E5191_2==1|E5193_2==1|E5194_2==1|E5200_2==1; 
replace eprhib3=0 if E5161==1; * only one employer-provided insurance;
replace eprhib3=0 if epins3==0; * no employer-provide insurance;
replace eprhib3=0 if insspb3==1;

* Is the spouse be covered by the employer-provide insurance ?;
gen epspa3=.;
gen temp=real(E5173001);
drop E5173001;
rename temp E5173001;
gen temp=real(E5173002);
drop E5173002;
rename temp E5173002;
gen temp=real(E5173003);
drop E5173003;
rename temp E5173003;
gen temp=real(E5173004);
drop E5173004;
rename temp E5173004;
gen temp=real(E5173005);
drop E5173005;
rename temp E5173005;
replace epspa3=1 if
E5173001==36|E5173002==36|E5173003==36|E5173004==36|E5173005==36;
replace epspa3=0 if E5173001~=36 & E5173001~=. & E5173002~=36 & E5173002~=. & 
E5173003~=36 & E5173003~=. & E5173004~=36 & E5173004~=. & E5173005~=36 & 
E5173005~=.; 
replace epspa3=0 if E5172_1==5|E5172_1==8;
* replace epspa3=0 if E5160==5|E5160==8|E5171_1==A|E5165_1==1; * true "INAP"case;
replace epspa3=0 if E5160==5|E5160==8|E5165_1==1; * true "INAP" cases;
* In the above statement "E5171_1==A" is deleted because no such cases exist;

replace epspa3=0 if E5157==1; * Self-employed;
replace epspa3=0 if epins3==0; * no employer-provided insurance; 
* Li's comment: note that there are not enough information about "partial 
intervew" and "loop Variable Q5162", which may cause more missing values
than other variables;


gen temp=real(E5173011);
drop E5173011;
rename temp E5173011;
gen temp=real(E5173012);
drop E5173012;
rename temp E5173012;
gen temp=real(E5173013);
drop E5173013;
rename temp E5173013;
gen temp=real(E5173014);
drop E5173014;
rename temp E5173014;
gen temp=real(E5173015);
drop E5173015;
rename temp E5173015;
gen epspb3=.;
replace epspb3=1 if
E5173011==36|E5173012==36|E5173013==36|E5173014==36|E5173015==36;
replace epspb3=0 if E5173011~=36 & E5173011~=. & E5173012~=36 & E5173012~=. & 
E5173013~=36 & E5173013~=. & E5173014~=36 & E5173014~=. & E5173015~=36 & 
E5173015~=.; 
replace epspb3=0 if E5172_2==5|E5172_2==8;
* replace epspb3=0 if E5160==5|E5160==8|E5171_2==A|E5165_2==1; * true "INAP"case;
replace epspb3=0 if E5160==5|E5160==8|E5165_2==1; * True "INAP" cases;
* In the above statement "E5171_2==A" is deleted because no such cases exist;

replace epspb3=0 if E5161==1; * only one employer-provide insurance;
replace epspb3=0 if E5157==1; * Self-employed;
replace epspb3=0 if epins3==0; * no employer-provided insurance; 
* Li's comment: note that there are not enough information about "partial 
intervew" and "loop Variable Q5162", which may cause more missing values
than other variables;

* Does employer provide insurance for spouse after retirement; 
gen eprspa3=.;
replace eprspa3=0 if E5193_1==5; * "DK" is not the same as "NO";
replace eprspa3=1 if E5193_1==1;
replace eprspa3=0 if E5160==5|E5160==8|E5184_1==2|E5190_1==1|E5165_1==1|
E5184_1==1|E5190_1==3|E5191_1==5|E5191_1==8|E5192_1==2;
replace eprspa3=0 if E5157==1; * self-employed;
replace eprspa3=0 if epins3==0; * no employer-provided insurance;

gen eprspb3=.;
replace eprspb3=0 if E5193_2==5; * "DK" is not the same as "NO";
replace eprspb3=1 if E5193_2==1;
replace eprspb3=0 if E5160==5|E5160==8|E5184_2==2|E5190_2==1|E5165_2==1|
E5184_2==1|E5190_2==3|E5191_2==5|E5191_2==8|E5192_2==2;
replace eprspb3=0 if E5161==1; * only one employer-provided insurance; 
replace eprspb3=0 if E5157==1; * self-employed;
replace eprspb3=0 if epins3==0; * no employer-provided insurance;

* private insurance?;
gen inspriv3=0;
gen insexch3=0;
replace inspriv3=1 if E5218==1;
replace inspriv3=0 if E5219==9|epins3==.;
replace inspriv3=0 if E5218==5|E5218==8;
replace inspriv3=1 if E5158==1; * self-employment;
replace inspriv3=1 if E5170_1==1|E5170_2==1|E5206==1; *Medigap;

* variables for whether people will loose health insurance after they leave their jobs;
gen eprhi3=eprhia3;
replace eprhi3=eprhib3 if eprhib3~=. & eprhia3==0;

* Is employer-provided insurance after retirement free ( or deduced cost)?
* not much information about this;
gen eprfr3=.; * not much information about eprfr3 for this wave;
replace eprfr3=0 if E5157==1; * self-employed;
replace eprfr3=0 if epins3==0; * no employer-provided insurance;

replace epfra3=0 if epins3==0;
replace eprhia3=0 if epins3==0;
* replace eprfra3=0 if epins3==0; * not much information about eprfr3 for this wave; 
replace epspa3=0 if epins3==0;
replace epspb3=0 if epins3==0;
replace eprhia3=0 if epins3==0;
replace eprhib3=0 if epins3==0;
replace eprspa3=0 if epins3==0;
replace eprspb3=0 if epins3==0;


gen epfr3=.;
replace epfr3=1 if epfra3==1|epfrb3==1;
replace epfr3=0 if epfra3==0 & epfrb3==0;
replace epfr3=0 if epins3==0;
* gen eprfr3=.; * not much information about eprfr3 for this wave; 
* replace eprfr3=1 if eprfra3==1|eprfrb3==1;
* replace eprfr3=0 if eprfra3==0 & eprfrb3==0;
* replace eprfr3=0 if epins3==0;
gen eprsp3=.;
replace eprsp3=1 if eprspa3==1|eprspb3==1;
replace eprsp3=0 if eprspa3==0 & eprspb3==0;
replace eprsp3=0 if epins3==0;
gen inssp3=.;
replace inssp3=1 if insspa3==1|insspb3==1;
replace inssp3=0 if insspa3==0 & insspb3==0;
replace inssp3=0 if epins3==0;
gen epsp3=.;
replace epsp3=1 if epspa3==1|epspb3==1;
replace epsp3=0 if epspa3==0 & epspb3==0;
replace epsp3=0 if epins3==0;
* This variable may have more missing values than other variables because of
some reason mentioned above;

* deactivate initial re-coding;
* gen epfr3=.;
* replace epfr3=1 if epfra3==1|epfrb3==1;
* replace epfr3=0 if epfr3~=1 & epfra3==0;
* gen eprfr3=.;
* replace eprfr3=1 if eprfra3==1|eprfrb3==1;
* replace eprfr3=0 if eprfr3~=1 & eprfra3==0;
* gen epfr3=.;
* replace eprfr3=1 if eprfra3==1|eprfrb3==1;
* replace eprfr3=0 if eprfr3~=1 & eprfra3==0;
* gen epsp3=.;
* replace epsp3=1 if epspa3==1|epspb3==1;
* replace epsp3=0 if epsp3~=1 & epspa3==0;
* gen inssp3=.;
* replace inssp3=1 if insspa3==1|insspb3==1;
* replace inssp3=0 if insspa3==0 & insspb3~=1;
* replace inssp3=0 if epins3==0;
*********variable for whether someone is covered by insurance;
gen insnot3=.;
replace insnot3=0 if E5237==1|E5247==2|E5266==1;
replace insnot3=1 if (E5238==1 & E5237==2 & E5247==1 & E5266==5);
*insnot==1 not covered by insurance at some point in time; 


keep HHID PN  ins* ep* medc*;
sort HHID PN;
merge HHID PN using `saved'insure;
drop _merge;
sort HHID PN;
save `saved'insure, replace;
drop _all;

******** WAVE IV *****************************************;
*408C: change filename from hrs98r, which no longer exists, to H98R_R, which is the assumed new equivalent;
*use `wave4d'hrs98r; 
use `wave4d'H98R_R;
gen temp=real(HHID);
drop HHID;
gen HHID=temp;
drop temp;
gen temp=real(PN);
drop PN;
gen PN=temp;
drop temp;

* medicare ? ;
*408C:rename F5866 (new variable labeled "MEDICARE COVERAGE" Q5866 (old variable labeled "MEDICARE COVERAGE");
rename F5866 Q5866;

gen medcare4=0;
replace medcare4=1 if Q5866==1;

* government provided insurance?;
gen insgov4=.;
*408C: renamed F5878 (the new variable labeled "CHAMPUS/CHAMPVA COVERAGE") Q5878 (the old variable labeled "CHAMPUS/CHAMPVA COVERAGE" which was used in the old insure.do);
rename F5878 Q5878;
*408C: renamed F5868 (the new variable labeled "MEDICAID SINCE PREV WAVE?" Q5868 (the old variable labeled "MEDICAID SINCE PREV WAVE?" which was used in the old insure.do);
rename F5868 Q5868;
*408C: renamed F5869 (the new variable labeled "CURRENTLY COVERED BY MEDICAID") Q5869 (the old variable labeled "CURRENTLY COVERED BY MEDICAID" which was used in the old insure.do);
rename F5869 Q5869;
*408C: renamed F5871 (the new variable labeled "MEDICAID AT TIME OF NURSING HOME-FIRS") Q5871 (the old variable labeled "MEDICAID AT TIME OF NURSING HOME-FIRS" which was used in the old insure.do);
rename F5871 Q5871;
*408C: renamed F5872 (the new variable labeled "MEDICAID DURING NURSING HOME-FIRST") Q5872 (the old variable labeled "MEDICAID DURING NURSING HOME-FIRST" which was used in the old insure.do);
rename F5872 Q5872;
*408C: renamed F5875 (the new variable labeled "MEDICAID AT TIME OF NURSING HOME-LA" Q5875 (the old variable labeled "MEDICAID AT TIME OF NURSING HOME-LA" which was used in the old insure.do);
rename F5875 Q5875;
*408C: renamed F5876 (the new variable labeled "MEDICAID DURING NURSING HOME-LAST" Q5876 (the old variable labeled "MEDICAID DURING NURSING HOME-LAST" which was used in the old insure.do);
rename F5876 Q5876;
replace insgov4=1 if Q5878==1; *VA\CHAMPUS;
replace insgov4=0 if Q5878==5|Q5878==8; * no information about "INAP" cases;
replace insgov4=2 if Q5868==1|Q5869==1|Q5871==1|Q5872==1|Q5875==1|Q5876==1; *Medicaid;

gen epins4=.;
gen epfr4=.;
gen eprhi4=.;
* gen eprfr4=.;  *generate later;
* gen eprsp4=.; * generate later;
gen epsp4=.; * generate later;

*employer provided health insurance?; 
*408C: renamed F5893 (the new variable labeled "ANY INSURANCE FOR HOSP/DR BILLS") Q5893 (the old variable labeled "ANY INSURANCE FOR HOSP/DR BILLS" which was used in the old insure.do);
rename F5893 Q5893;
replace epins4=1 if Q5893==1 ; 
replace epins4=0 if Q5893==5|Q5893==8;
*408C: renamed F5891 (the new variable labeled "SELF-EMP INSURANCE") Q5891 (the old variable labeled "SELF-EMP INSURANCE" which was used in the old insure.do);
rename F5891 Q5891;
replace epins4=0 if Q5891==1; * self-employed;
* Note: Here I treat "self-employed" cases as 0 values;

* is the health insurance is free (or reduced cost)?;
*408C: renamed F5899 (the new variable labeled "PAY COSTS FOR HEALTH INSURANCE") Q5899 (the old variable labeled "PAY COSTS FOR HEALTH INSURANCE" which was used in the old insure.do);
rename F5899 Q5899;
replace epfr4=0 if Q5899==1;
replace epfr4=0 if Q5893==0|Q5893==5|Q5893==8; * no emploer-provided insurance;
*408C: renamed F5898 (the new variable labeled "CHECKPOINT") Q5898 (the old variable labeled "CHECKPOINT" which was used in the old insure.do);
rename F5898 Q5898;
replace epfr4=0 if Q5898==1; * get insurance from spouse's employer or union; 
replace epfr4=1 if Q5899==2|Q5899==3;

* is the spouse be covered by the employer-provided insurance?;
*408C: renamed F5906M1 (the new variable labeled "WHO COVERED?") Q5906M1 (the old variable labeled "WHO COVERED?" which was used in the old insure.do);

rename F5906M1 Q5906M1;
*408C: renamed 5906M2 (the new variable labeled "WHO COVERED?") Q5906M2 (the old variable labeled "WHO COVERED?" which was used in the old insure.do);
rename F5906M2 Q5906M2;
*408C: renamed 5906M3 (the new variable labeled "WHO COVERED?") Q5906M3 (the old variable labeled "WHO COVERED?" which was used in the old insure.do);
rename F5906M3 Q5906M3;
*408C: renamed 5906M4 (the new variable labeled "WHO COVERED?") Q5906M4 (the old variable labeled "WHO COVERED?" which was used in the old insure.do);
rename F5906M4 Q5906M4;
gen temp=real(Q5906M1);
drop Q5906M1;
gen Q5906M1=temp;
drop temp;
gen temp=real(Q5906M2);
drop Q5906M2;
gen Q5906M2=temp;
drop temp;
gen temp=real(Q5906M3);
drop Q5906M3;
gen Q5906M3=temp;
drop temp;
gen temp=real(Q5906M4);
drop Q5906M4;
gen Q5906M4=temp;
drop temp;
replace epsp4=1 if Q5906M1==36|Q5906M2==36|Q5906M3==36|Q5906M4==36;
replace epsp4=0 if Q5893==0|Q5893==5|Q5893==8; * no insurance from employer;
replace epsp4=0 if Q5898==1; * get insurance from spouse's employer or union;
*408C: renamed F5904 (new variable labeled "PLAN LETTER") Q5904 (old variable labeled "PLAN LETTER" used in the old insure.do);
rename F5904 Q5904;
*408C: coding has changed so that plan letter A is coded as the number 1 (it is no longer a string). Changed following line accordingly.;
*replace epsp4=0 if Q5904=="A"; * plan letter=A;
replace epsp4=0 if Q5904==1;
*408C: renamed F5905 (new variable labeled "ANYONE ELSE COVERED") to Q5905 (old variable labeled "ANYONE ELSE COVERED" used in the old insure.do);
rename F5905 Q5905;
replace epsp4=0 if Q5905==5|Q5905==8; * No one else covered; 
*408C: renamed 5906M5 (the new variable labeled "WHO COVERED?") Q5906M5 (the old variable labeled "WHO COVERED?" which was used in the old insure.do);
rename F5906M5 Q5906M5;
*408C: renamed 5906M6 (the new variable labeled "WHO COVERED?") Q5906M6 (the old variable labeled "WHO COVERED?" which was used in the old insure.do);
rename F5906M6 Q5906M6;
gen temp=real(Q5906M5);
drop Q5906M5;
gen Q5906M5=temp;
drop temp;
gen temp=real(Q5906M6);
drop Q5906M6;
gen Q5906M6=temp;
drop temp;





replace epsp4=0 if (Q5906M1~=1 & Q5906M1~=36 & Q5906M1~=99) & (Q5906M2~=1 & Q5906M2~=36 & Q5906M2~=99) &
(Q5906M3~=1 & Q5906M3~=36 & Q5906M3~=99) & (Q5906M4~=1 & Q5906M4~=36 & Q5906M4~=99) & 
(Q5906M5~=1 & Q5906M5~=36 & Q5906M5~=99) & (Q5906M6~=1 & Q5906M6~=36 & Q5906M6~=99);
replace epsp4=0 if epins4==0; * no insurance from employer;
* initial re-coding: replace epsp4=0 if epsp4~=1; * this isn't consistent with what I've done before;

* get employer-provided insurance through spouse's employer/union or not;
gen inssp4=.;
*408C: rename F5896 (new variable labeled "HOW OBTAIN INSURANCE") Q5896 (old variable labeled "HOW OBTAIN INSURANCE" which was used in the old insure.do);
rename F5896 Q5896;
replace inssp4=1 if Q5896==4|Q5896==5|Q5896==6; * spouse's employer/union;
replace inssp4=0 if Q5896==1|Q5896==2|Q5896==3; * own employer/union;
replace inssp4=0 if Q5893==0|Q5893==5|Q5893==8; * no insurance from employer;
*408C: rename F5890 (new variable labeled "CHECKPOINT") Q5890 (old variable labeled "CHECKPOINT" which was used in the old insure.do);
rename F5890 Q5890;
replace inssp4=0 if Q5890==1; * self-employed;
replace inssp4=0 if Q5896==7; * get insurance from someplace else;
replace inssp4=0 if epins4==0; * may be redundant;
 
* deactivate initial re-coding, since I think it is Q5924 instead of Q5927;
* does employer provide retiree health insurance;
* replace eprhi4=0 if Q5927==5|Q5927==8|epins4==0;
* replace eprhi4=1 if Q5927==1;
* replace eprhi4=1 if Q5924==1;

* does employer provide retiree health insurance;
* Note: Q5924==" Can you continue this insurance coverage for yourself up to the age of 65?",
        Q5927==" If you left your current employer now, could you continue this health insurance coverage 
        for yourself up to the age of 65?".
  To be compatible with previous waves, it seems that Q5924 is the right variable; 

*408C: rename F5924 (new variable labeled "COVERAGE CONTINUE TO 65") Q5924 (old variable labeled "COVERAGE CONTINUE TO 65" which was used in the old insure.do);
rename F5924 Q5924;
replace eprhi4=0 if Q5924==5; * Here " DK" is not assumed to be same as "no" since this is about uncertain future;
*408C: rename F5917 (new variable labeled "CHECKPOINT") Q5917 (old variable labeled "CHECKPOINT" which was used in old insure.do);
rename F5917 Q5917;
*408C: rename F5923 (new variable labeled "CHECKPOINT") Q5923 (old variable labeled "CHECKPOINT" which was used in old insure.do);
rename F5923 Q5923;
replace eprhi4=0 if Q5898==1|Q5917==1|Q5917==2|Q5893==0|Q5893==5|Q5893==8|Q5923==3|Q5923==1; * "INAP" cases;
replace eprhi4=0 if epins4==0;
*408C: rename F5927 (new variable labeled "COVERAGE TO 65 IF LEFT NOW") Q5927 (old variable labeled "COVERAGE TO 65 IF LEFT NOW" which was used in the old insure.do);
rename F5927 Q5927;
replace eprhi4=1 if Q5924==1|Q5927==1;
replace eprhi4=0 if inssp4==1; * get insurance from spouse's emplloyer/union;

* will the spouse be covered after retirement?;
gen eprsp4=.;
*408C: rename F5926 (new variable labeled "COVERAGE CONTINUE FOR SP UP TO 65") Q5926 (old variable labeled "COVERAGE CONTINUE FOR SP UP TO 65" which was used in the old insure.do);
rename F5926 Q5926;
replace eprsp4=1 if Q5926==1;
replace eprsp4=0 if Q5926~=1;
replace eprsp4=. if Q5926==8|Q5926==9; * "DK" and "RF" cases;
replace eprsp4=. if Q5893==9; * "RF" for "covered by employer-provided insurance or no";
replace eprsp4=. if Q5924==8|Q5924==9; * "DK" and "RF" cases for 
" can you continue your insurance coverage for yourself up to the age of 65?";

* is the employer-provided insurance after retirement free (or at reduced cost)?;
gen eprfr4=.; * data for this variable is not available; 
replace eprfr4=0 if epins4==0; * no employer-provided insurance;


*private insurance;
gen inspriv4=0;
gen insexch4=0;
replace inspriv4=0 if Q5866==1; * "covered by medicare";
replace inspriv4=0 if Q5869==1; * covered by medicaid;
replace inspriv4=0 if Q5878==1; * covered by government insurance;
replace inspriv4=0 if Q5893==1; * covered by employer-provided insurance;
*408C: renamed F5950 (new variable labeled "ANY OTHER HEALTH INSUR") Q5950 (old variable labeled "ANY OTHER HEALTH INSUR" which was used in old insure.do);
rename F5950 Q5950;
replace inspriv4=1 if Q5950==1;
replace inspriv4=0 if Q5950==0|Q5950==5|Q5950==8|5950==.; * "INAP", "No" and "DK" cases;
replace inspriv4=1 if Q5891==1;
*408C: renamed F5938 (new variable labeled "OTHER INSURANCE") Q5938 (old variable labeled "OTHER INSURANCE" which was used in old insure.do);
rename F5938 Q5938;
replace inspriv4=1 if Q5938==1;

*no employer provided health insurance;
replace epfr4=0 if epins4==0;
replace eprhi4=0 if epins4==0;
replace eprfr4=0 if epins4==0;
replace epsp4=0 if epins4==0;
replace inssp4=0 if epins4==0;
keep HHID PN ins* ep* medc*;

sort HHID PN;
merge HHID PN using `saved'insure;
drop _merge;

* only use condensed information on health plans;
*drop 
insspa1 insspb1 insspa2 insspb2 insspa3 insspb3
epfra1 epfrb1 epfra2 epfrb2 epfra3 epfrb3
eprspa1 eprspb1 eprspa2 eprspb2 epspa3 epspb3
eprhia1 eprhib1 eprhia2 eprhib2 eprhia3 eprhib3;
drop eprfra1 eprfrb1 eprfra2 eprfrb2;

*make some empty variables;
* gen epsp1=.; * We have some information about this variable;
* gen epsp2=.; * We have some information about this variable;
* gen eprsp3=.; * We have some information about this variable;
* gen eprsp4=.; * We have some information about this variable;

sort HHID PN;
save `saved'insure, replace;
drop _all;

************************ WAVE V *********************************;
*408C: changed filename from h00_r, which no longer exists, to H00R_R, the assumed new equivalent;
*use `wave5d'h00_r;
use `wave5d'H00R_R;

gen temp=real(HHID);
drop HHID;
gen HHID=temp;
drop temp;
gen temp=real(PN);
drop PN;
gen PN=temp;
drop temp;

* medicare ? ;
gen medcare5=0;
*408C: renamed G6238 (new variable labeled "MEDICARE COVERAGE") Q6238 (old variable labeled "MEDICARE COVERAGE" that was used in old insure.do file);
rename G6238 Q6238;
replace medcare5=1 if Q6238==1;

* government provided insurance?;
gen insgov5=.;
*408C: renamed G6251 (new variable labeled "CHAMPUS/CHAMPVA COVERAGE") Q6251 (old variable labeled "CHAMPUS/CHAMPVA COVERAGE" that was used in old insure.do file);
rename G6251 Q6251;
replace insgov5=1 if Q6251==1;
replace insgov5=0 if Q6251==5|Q6251==8;*and Q6251 is R9 Champus/Champva coverage question;
*408C: renamed G6241 (new variable labeled "MEDICAID SINCE PREV WAVE?") Q6241 (old variable labeled "MEDICAID SINCE PREV WAVE?" that was used in old insure.do file);
rename G6241 Q6241;
*408C: renamed G6242 (new variable labeled "CURRENTLY COVERED BY MEDICAID") Q6242 (old variable labeled "CURRENTLY COVERED BY MEDICAID" that was used in old insure.do file);
rename G6242 Q6242;
*408C: renamed G6244 (new variable labeled "ELIG MEDICAID START NH STAY-1ST") Q6244 (old variable labeled "ELIG MEDICAID START NH STAY-1ST" that was used in old insure.do file);
rename G6244 Q6244;
*408C: renamed G6245 (new variable labeled "BEC ELIG MEDICAID DUR STAY-1ST") Q6245 (old variable labeled "BEC ELIG MEDICAID DUR STAY-1ST" that was used in old insure.do;
rename G6245 Q6245;
*408C: renamed G6248 (new variable labeled "ELIG MEDICAID START NH STAY-LAST") Q6248 (old variable labeled "ELIG MEDICAID START NH STAY-LAST" that was used in old insure.do);
rename G6248 Q6248;
*408C: renamed G6249 (new variable labeled "BEC ELIG MEDICAID DUR NH STAY-LAST") Q6249 (old variable labeled "BEC ELIG MEDICAID DUR NH STAY-LAST" that was used in old insure.do);
rename G6249 Q6249;
replace insgov5=2 if Q6241==1|Q6242==1|Q6244==1|Q6245==1|Q6248==1|Q6249==1;

gen epins5=.;
gen epfr5=.;
gen eprhi5=.;
gen eprfr5=.;
gen epsp5=.; 

*employer provided health insurance?; 
*408C: renamed G6266 (new variable labeled "ANY INSURANCE THRU AN EMPLOYER") Q6266 (old variable labeled "ANY INSURANCE THRU AN EMPLOYER" that was used in old insure.do);
rename G6266 Q6266;
*408C: renamed G6264 (new variable labeled "SELF-EMP INSURANCE") Q6264 (old variable labeled "SELF-EMP INSURANCE" that was used in old insure.do);
rename G6264 Q6264;
replace epins5=1 if Q6266==1 ; 
replace epins5=0 if Q6266==5|Q6266==8;
replace epins5=0 if Q6264==1; * self-employed; 
 

* is the health insurance free (or reduced cost)?;
*408C: renamed G6272 (new variable labeled "PAY COSTS FOR HEALTH INSURANCE") Q6272 (old variable labeled "PAY COSTS FOR HEALTH INSURANCE" that was used in old insure.do);
rename G6272 Q6272;
replace epfr5=0 if Q6272==1;
replace epfr5=1 if Q6272==2|Q6272==3;
replace epfr5=0 if Q6264==1; * self-employed;
replace epfr5=0 if Q6266==5|Q6266==8; * no employer-provided insurance;
*408C: renamed G6271 (new variable labeled "CHECKPOINT") Q6271 (old variable labeled "CHECKPOINT" that was used in old insure.do);
rename G6271 Q6271;
replace epfr5=0 if Q6271==1; * obtain employer-provided insurance from spouse;
replace epfr5=0 if epins5==0; * no employer-provided insurance; * maybe 
unnecessary;

* is the spouse be covered by the employer-provided insurance?;
*408C: renamed G6279M1-G6279M7 (new variables labeled "WHO COVERED?") Q6279M1-Q6279M7 (old variables labeled "WHO COVERED?" that were used in old insure.do);
rename G6279M1 Q6279M1;
rename G6279M2 Q6279M2;
rename G6279M3 Q6279M3;
rename G6279M4 Q6279M4;
rename G6279M5 Q6279M5;
rename G6279M6 Q6279M6;
rename G6279M7 Q6279M7;
*408C: fixed type;
gen temp=real(Q6279M1);
drop Q6279M1;
gen Q6279M1=temp;
drop temp;
gen temp=real(Q6279M2);
drop Q6279M2;
gen Q6279M2=temp;
drop temp;
gen temp=real(Q6279M3);
drop Q6279M3;
gen Q6279M3=temp;
drop temp;
gen temp=real(Q6279M4);
drop Q6279M4;
gen Q6279M4=temp;
drop temp;
gen temp=real(Q6279M5);
drop Q6279M5;
gen Q6279M5=temp;
drop temp;
gen temp=real(Q6279M6);
drop Q6279M6;
gen Q6279M6=temp;
drop temp;
gen temp=real(Q6279M7);
drop Q6279M7;
gen Q6279M7=temp;
drop temp;
replace epsp5=1 if Q6279M1==36|Q6279M2==36|Q6279M3==36|Q6279M4==36|Q6279M5==36|
Q6279M6==36|Q6279M7==36;
replace epsp5=0 if Q6279M1~=36 & Q6279M2~=36 & Q6279M3~=36 & Q6279M4~=36 & 
Q6279M5~=36 & Q6279M6~=36 & Q6279M7~=36; * 0 value for "spouse not covered" , "INAP", "RF" ;
replace epsp5=. if (Q6279M1==99|Q6279M1==.) & (Q6279M2==99|Q6279M2==.) & 
(Q6279M3==99|Q6279M3==.) & (Q6279M4==99|Q6279M4==.) & (Q6279M5==99|Q6279M5==.) 
& (Q6279M6==99|Q6279M6==.) & (Q6279M7==99|Q6279M7==.); * re-set value from 0 to
missing for "RF" and "INAP" cases;

* The following is for re-setting value from missing to 0 for "INAP" cases for
Q6279M1-7;
* Li's comment: There are about 1200 "RF". For epsp5 I have done the best to
minimize the missing values;
 
replace epsp5=0 if Q6264==1; * self-employed;
replace epsp5=0 if Q6266==5|Q6266==8; * no employer-provided insurance; 
replace epsp5=0 if Q6271==1; * obtain employer-provided insurance from spouse;
*408C: renamed G6277 (new variable labeled "PLAN LETTER") Q6277 (old variable labeled "PLAN LETTER" that was used in old insure.do);
rename G6277 Q6277;
replace epsp5=0 if Q6277==1; * plan letter=A;
*408C: renamed G6278 (new variable labeled "ANYONE ELSE COVERED") Q6278 (old variable labeled "ANYONE ELSE COVERED" that was used in old insure.do);
rename G6278 Q6278;
replace epsp5=0 if Q6278==5|Q6278==8; * No one else is covered by the employer-
provided insurance;
replace epsp5=0 if epins5==0; * no employer-provided insurance;




* get employer-provided insurance from spouse's firm ( as opposed to own firm);
gen inssp5=.;
*408C:rename G6269 (new variable labeled "HOW OBTAIN INSURANCE") Q6269 (old variable labeled "HOW OBTAIN INSURANCE" that was used in old insure.do);
rename G6269 Q6269;
replace inssp5=1 if Q6269>3 & Q6269<7 & Q6269~=.; * spouse;  
replace inssp5=0 if Q6269>0 & Q6269<4 & Q6269~=.; * own;
replace inssp5=0 if Q6269==7; * get employer-provided insurance from someplace 
else;

* does employer provide retiree health insurance;
*408C:rename G6297 (new variable labeled "COVERAGE CONTINUE TO 65") Q6297 (old variable labeled "COVERAGE CONTINUE TO 65" that was used in old insure.do);
rename G6297 Q6297;
*408C:rename G6298 (new variable labeled "COVRGE OFFER BY EMPLYR AFT 65") Q6298 (old variable labeled "COVRGE OFFER BY EMPLYR AFT 65" that was used in old insure.do);
rename G6298 Q6298;
*408C:rename G6302 (new variable labeled "COVERAGE TO 65 IF LEFT NOW") Q6302 (old variable labeled "COVERAGE TO 65 IF LEFT NOW" that was used in old insure.do);
rename G6302 Q6302;
*408C:rename G6303 (new variable labeled "COVERAGE AFTER 65 IF LEFT NOW") Q6303 (old variable labeled "COVERAGE AFTER 65 IF LEFT NOW" that was used in old insure.do);
rename G6303 Q6303;

replace eprhi5=1 if Q6297==1|Q6298==1|Q6302==1|Q6303==1;
replace eprhi5=0 if Q6266==5|Q6266==8; * no employer-provided insurance;
replace eprhi5=0 if Q6271==1; * obtain employer-provided insurance from spouse;
replace eprhi5=0 if epins5==0; * no employer-provided insurance;
replace eprhi5=0 if eprhi5==. & epins5~=.;
replace eprhi5=0 if inssp5==1;
summ eprhi5;


* Will the insurance cover the spouse after retirement?; 
gen eprsp5=.;
*408C:rename G6300 (new variable labeled "COVERAGE CONTINUE FOR SP TO 65") Q6300 (old variable labeled "COVERAGE CONTINUE FOR SP TO 65" that was used in old insure.do);
rename G6300 Q6300;
replace eprsp5=0 if Q6300==5|Q6300==8;
replace eprsp5=0 if Q6264==1; * self-employed; 
replace eprsp5=0 if Q6266==5|Q6266==8; * no employer-provided insurance;
replace eprsp5=0 if Q6271==1; * get employer-provided insurance through spouse;
*408C: rename G6290 (new variable labeled "CHECKPOINT") Q6290 (old variable labeled "CHECKPOINT" that was used in old insure.do);
rename G6290 Q6290;
replace eprsp5=0 if Q6290==1|Q6290==2; * self-employed and business pays for
health insurance, or "get employer-provided insurance from someplace else";
*408C: rename G6296 (new variable labeled "CHECKPOINT") Q6296 (old variable labeled "CHECKPOINT" that was used in old insure.do);
rename G6296 Q6296;
replace eprsp5=0 if Q6296==3; * get employer-provided insurance through spouse,
or more than 65 years old;
replace eprsp5=0 if Q6296==1; * get employer-provided insurance from current 
employer and less than 65 years old;
replace eprsp5=0 if Q6297==5|Q6297==8; * * can't get insurance through employer 
for yourself after retirement; 
*408C:rename G6299 (new variable labeled "BRANCHPOINT") Q6299 (old variable labeled "BRANCHPOINT" that was used in old insure.do);
rename G6299 Q6299;
replace eprsp5=0 if Q6299==2; * spouse not covered under policy or spouse is 
older than 65;
*408C:rename G6301 (new variable labeled "COVERAGE FOR SPOUSE AFTER 65") Q6301 (old variable labeled "COVERAGE FOR SPOUSE AFTER 65" that was used in old insure.do);
rename G6301 Q6301;
*408C:rename G6307 (new variable labeled "COVERAGE TO 65 FOR SP IF LEFT NOW") Q6307 (old variable labeled "COVERAGE TO 65 FOR SP IF LEFT NOW" that was used in old insure.do);
rename G6307 Q6307;
*408C:rename G6308 (new variable labeled "COVRGE FOR SP AFT 65 IF LEFT NOW") Q6308 (old variable labeled "COVRGE FOR SP AFT 65 IF LEFT NOW" that was used in old insure.do);
rename G6308 Q6308;
replace eprsp5=1 if Q6300==1|Q6301==1|Q6307==1|Q6308==1;
replace eprsp5=0 if epins5==0; * no employer-provided insurance;

* Is the employer-provided insurance after retirement free( or deduced costs)?;
* gen eprfr5=.; * not much information about this variable;
* replace eprfr5=0 if Q6264==1; * self-employed;
replace eprfr5=0 if epins5==0; * no employer-provided insurance; 


*private insurance?;
gen inspriv5=.;
gen insexch5=0;
replace inspriv5=0 if Q6238==1; * Covered by medicare; 
replace inspriv5=0 if Q6242==1|Q6251==1|Q6266==1; * covered by medicaid, covered
replace inspriv5=0 if epins5==1;
*408C:rename G6324 (new variable labeled "ANY HEALTH INSUR") Q6324 (old variable labeled "ANY HEALTH INSUR" that was used in old insure.do);
rename G6324 Q6324;
replace inspriv5=1 if Q6324==1;
replace inspriv5=0 if Q6324==5|Q6324==8;
replace inspriv5=1 if Q6264==1; * self-employed;
replace inspriv5=1 if Q6290==1; * self-employed and business pays health
insurance;
*408C:rename G6312 (new variable labeled "OTHER INSURANCE") Q6312 (old variable labeled "OTHER INSURANCE" that was used in old insure.do);
rename G6312 Q6312;
replace inspriv5=1 if Q6312==1; *no employer provided health insurance;

sum inspriv5;
*408C:rename G6325 (new variable labeled "ANY OTHER PURCHASED HEALTH INS") Q6325 (old variable labeled "ANY OTHER PURCHASED HEALTH INS" that was used in old insure.do);
rename G6325 Q6325;

replace inspriv5=1 if Q6325==1|Q6324==1;

sum inspriv5;


replace epfr5=0 if epins5==0;
replace eprhi5=0 if epins5==0;
replace epsp5=0 if epins5==0;
replace inssp5=0 if epins5==0;
replace eprfr5=0 if epins5==0;

* FSK code for wave 5;
* with renames of G6 to Q6 as per above ;
gen medigap1=.;
gen medigap2=.;
gen medigap3=.;
gen medigap4=.;
*gen medigap7=.;
*gen medigap8=.;
*gen medigap9=.;
*gen medigap10=.;
*gen medigap11=.;
gen medigap12=.;
gen medigap13=.;
gen medigap14=.;
gen medigap15=.;

gen mcare=1 if Q6238==1;
replace mcare=0 if Q6238==5;

gen medicaid=1 if Q6242==1;
replace medicaid=0 if Q6242>1;

gen tri_care=1 if Q6251==1;
replace tri_care=0 if Q6251>1 & Q6251<8;


gen medigap5=0 if Q6266==5;
replace medigap5=1 if Q6269==3 | Q6269==6 | Q6269==7;
replace medigap5=1 if Q6312==1;
replace medigap5=0 if Q6312==5 & medigap5==.;

* We treat as missing, those who have no medicare, those covered by medicaid or VA/CHAMPUS,;
* those who purchased employer-provided health insurance and ;
* those who have self-purchased private insurance that they do not pay for.;

replace medigap5=. if mcare==0 | medicaid==1 | tri_care==1;
replace medigap5=. if mcare==1 & (Q6269==1 | Q6269==2 | Q6269==4 | Q6269==5) & medigap5==0;
replace medigap5=. if mcare==1 & (G6314==3 | Q6272==3);

summ medigap5 inspriv5;
tab medigap5 inspriv5, missing;
* end FSK code;

*HALT;

keep HHID PN ins* ep* medc* medigap* Q6264; 
sum medc*;

sort HHID PN;
merge HHID PN using `saved'insure;
drop _merge;
summ;

sort HHID PN;
save `saved'insure, replace;
drop _all;













*WORKING ON WAVE 6 NOW;

*codebook is at:

*http://hrsonline.isr.umich.edu/meta/2002/core/codebook/h02n_ri.htm;

************************ WAVE VI *********************************;

*quietly infile using `wave6d'H02J_R.dct;
use `wave6d'H02J_R;
gen self = .;
replace self = 1 if HJ021 == 2; *Note, if someone's secondary job isn't self employed, they will be missed, however most part time jobs don't include health insurance, so I don't think we'll have to worry about miscoding those people.;

gen temp=real(HHID);
drop HHID;
rename temp HHID;
gen temp=real(PN);
drop PN;
rename temp PN;
sort HHID PN;

keep self HHID PN;

save "`saved'selfemp", replace;
clear;

*quietly infile using `wave6d'H02N_R.dct;
use `wave6d'H02N_R;


gen temp=real(HHID);
drop HHID;
rename temp HHID;
gen temp=real(PN);
drop PN;
rename temp PN;
sort HHID PN;

merge HHID PN using `saved'selfemp;
drop _merge;

* medicare ? ;
gen medcare6=0;
replace medcare6=1 if HN001==1;

* government provided insurance?;
gen insgov6=0;
replace insgov6=1 if HN007==1; * Champus/Champva coverage question;
replace insgov6=2 if HN005==1|HN006==1; * Did you have Medicaid over the last 2 yrs?;
gen epins6=.;
gen epins6a=.;
gen epins6b=.;
gen epins6c=.;
gen epfr6=.;
gen epfr6a=.;
gen epfr6b=.;
gen epfr6c=.;
gen eprhi6=.;
gen eprfr6=.;
gen epsp6=.; 


*** QUESTION 1 ***;
*employer provided health insurance?; 
replace epins6a=0 if HN033_1==5|HN034_1==5|HN023==0;
replace epins6a=1 if HN033_1==1;
replace epins6a=0 if self==1; * self-employed;
replace epins6a=1 if HN034_1==1; 


* is the health insurance free (or reduced cost)?;
replace epfr6a=0 if HN039_1==1;
replace epfr6a=1 if HN039_1==2|HN039_1==3;
replace epfr6a=0 if self==1; * self-employed;
replace epfr6a=0 if HN036_1==5|HN036_1==8; * no employer-provided insurance;
replace epfr6a=0 if HN035_1==1; * obtain employer-provided insurance from spouse;
replace epfr6a=0 if epins6a==0; * no employer-provided insurance; * maybe unnecessary;

*** QUESTION 2 ***;
*employer provided health insurance?; 
replace epins6b=0 if HN033_2==5|HN034_2==5|HN023<2;
replace epins6b=1 if HN033_2==1; 
replace epins6b=0 if self==1; * self-employed; 
replace epins6b=1 if HN034_2==1; 

* is the health insurance free (or reduced cost)?;
replace epfr6b=0 if HN039_2==1;
replace epfr6b=1 if HN039_2==2|HN039_2==3;
replace epfr6b=0 if self==1; * self-employed;
replace epfr6b=0 if HN036_2==5|HN036_2==8; * no employer-provided insurance;
replace epfr6b=0 if HN035_2==1; * obtain employer-provided insurance from spouse;
replace epfr6b=0 if epins6b==0; * no employer-provided insurance; * maybe unnecessary;

*** QUESTION 3 ***;
*employer provided health insurance?; 
replace epins6c=0 if HN033_3==5|HN034_3==5|HN023<3;
replace epins6c=1 if HN033_3==1;
replace epins6c=0 if self==1; * self-employed;
replace epins6c=1 if HN034_3==1; 

* is the health insurance free (or reduced cost)?;
replace epfr6c=0 if HN039_3==1;
replace epfr6c=1 if HN039_3==2|HN039_3==3;
replace epfr6c=0 if self==1; * self-employed;
replace epfr6c=0 if HN036_3==5|HN036_3==8; * no employer-provided insurance;
replace epfr6c=0 if HN035_3==1; * obtain employer-provided insurance from spouse;
replace epfr6c=0 if epins6c==0; * no employer-provided insurance; * maybe unnecessary;

***consolidate***;
replace epins6 = 1 if (epins6a == 1 | epins6b == 1 | epins6c == 1);

tab epins6;

replace epfr6 = 1 if (epfr6a == 1 | epfr6b == 1 | epfr6c == 1);
replace epins6 = 0 if (epins6a == 0 & epins6b == 0 & epins6c == 0);

tab epins6;

replace epfr6 = 0 if (epfr6a == 0 & epfr6b == 0 & epfr6c == 0);


* is the spouse be covered by the employer-provided insurance?;
gen t2 = real(HN049_1A);
drop HN049_1A;
rename t2 HN049_1A;
gen t2 = real(HN049_1B);
drop HN049_1B;
rename t2 HN049_1B;
gen t2 = real(HN049_1C);
drop HN049_1C;
rename t2 HN049_1C;
gen t2 = real(HN049_1D);
drop HN049_1D;
rename t2 HN049_1D;
gen t2 = real(HN049_1E);
drop HN049_1E;
rename t2 HN049_1E;
gen t2 = real(HN049_1F);
drop HN049_1F;
rename t2 HN049_1F;

gen t2 = real(HN049_2A);
drop HN049_2A;
rename t2 HN049_2A;
gen t2 = real(HN049_2B);
drop HN049_2B;
rename t2 HN049_2B;
gen t2 = real(HN049_2C);
drop HN049_2C;
rename t2 HN049_2C;
gen t2 = real(HN049_2D);
drop HN049_2D;
rename t2 HN049_2D;
gen t2 = real(HN049_3A);
drop HN049_3A;
rename t2 HN049_3A;
gen t2 = real(HN049_3B);
drop HN049_3B;
rename t2 HN049_3B;
gen t2 = real(HN049_3C);
drop HN049_3C;
rename t2 HN049_3C;
gen t2 = real(HN049_3D);
drop HN049_3D;
rename t2 HN049_3D;

replace epsp6=1 if HN049_1A==991 | HN049_1B==991 | HN049_1C==991 | HN049_1D==991 | HN049_1E==991 | HN049_1F==991;
replace epsp6=1 if HN049_2A==991 | HN049_2B==991 | HN049_2C==991 | HN049_2D==991;
replace epsp6=1 if HN049_3A==991 | HN049_3B==991 | HN049_3C==991 | HN049_3D==991;

replace epsp6=0 if HN049_1A~=991 & HN049_1B~=991 & HN049_1C~=991 & HN049_1D~=991 & HN049_1E~=991 & HN049_1F~=991 & HN049_2A~=991 & HN049_2B~=991 & HN049_2C~=991 & HN049_2D~=991 & HN049_3A~=991 & HN049_3B~=991 & HN049_3C~=991 & HN049_3D~=991;

replace epsp6=. if (HN049_1A==999 | HN049_1A == .) & (HN049_1B==999 | HN049_1B==. ) & (HN049_1C==999 | HN049_1C==.) & (HN049_1D==999 | HN049_1D==.) & (HN049_1E==999 | HN049_1E==.) & (HN049_1F==999 | HN049_1F==.) & (HN049_2A==999 | HN049_2A==.) & (HN049_2B==999 | HN049_2B==.) & (HN049_2C==999 | HN049_2C==.) & (HN049_2D==999 | HN049_2D==.) & (HN049_3A==999 | HN049_3A==.) & (HN049_3B==999 | HN049_3B==.) & (HN049_3C==999 | HN049_3C==.) & (HN049_3D==999 | HN049_3D==.);
* re-set value from 0 to missing for "RF" and "INAP" cases;



* The following is for re-setting value from missing to 0 for "INAP" cases for HN049_1A-3D;
 
replace epsp6=0 if self==1; * self-employed;
replace epsp6=0 if epins6 ~=1; * no employer-provided insurance; 
replace epsp6=0 if HN035_1==1; * obtain employer-provided insurance from spouse;
replace epsp6=0 if HN035_2==1; * obtain employer-provided insurance from spouse;
replace epsp6=0 if HN035_3==1; * obtain employer-provided insurance from spouse;
replace epsp6=0 if HN026_1==1; * plan letter=A;
replace epsp6=0 if HN026_2==1; * plan letter=A;
replace epsp6=0 if HN026_3==1; * plan letter=A;
replace epsp6=0 if HN048_1==5|HN048_1==8; * No one else is covered by the employer-provided insurance;
replace epsp6=0 if HN048_2==5|HN048_2==8;
replace epsp6=0 if HN048_3==5|HN048_3==8;



* get employer-provided insurance from spouse's firm ( as opposed to own firm);
gen inssp6=.;


*replace inssp6=0 if HN023==0|epins6==1|(HN035_1==5 & HN036_1==5);
*replace inssp6=0 if self==1 & HN033_1==1;
replace inssp6=0;
replace inssp6=. if HN035_1 == 8 | HN036_1 == 8 | HN035_1 == 9 | HN036_1 == 9;
replace inssp6 = 1 if HN035_1 == 1 | HN036_1 == 1; * spouse; 
replace inssp6 = 1 if HN035_2 == 1 | HN036_2 == 1; * spouse;  
replace inssp6 = 1 if HN035_3 == 1 | HN036_3 == 1; * spouse; 
replace epins6=1 if inssp6==1;

tab epins6;

sum inssp*;


* does employer provide retiree health insurance;
* note: HN60_1 asks about whether those over 65 can keep their employer provided coverage;
* think about what to do with this one;
replace eprhi6 = 1 if HN059_1 == 1 | HN060_1 == 1;
replace eprhi6 = 1 if HN059_2 == 1 | HN060_2 == 1;
replace eprhi6 = 1 if HN059_3 == 1 | HN060_3 == 1;
replace eprhi6=0 if epins6 == 0; * no employer-provided insurance;
replace eprhi6=0 if inssp6==1; * obtain employer-provided insurance from spouse;
replace eprhi6=0 if eprhi6==. & epins6~=.;
summ eprhi6;



* Will the insurance cover the spouse after retirement?; 
gen eprsp6=.;
replace eprsp6=1 if HN062_1==1 | HN063_1==1;
replace eprsp6=1 if HN062_2==1 | HN063_2==1;
replace eprsp6=1 if HN062_3==1 | HN063_3==1;
replace eprsp6=0 if self==1; * self-employed; 
replace eprsp6=0 if epins6==0; * no employer-provided insurance;
replace eprsp6=0 if inssp6==1; * get employer-provided insurance through spouse;
replace eprsp6=0 if eprsp6==. & (HN062_1~=8 |HN062_1~=9 |HN063_1~=8 | HN063_1~=9);

*Note, there are several "checkpoints" in wave 5 for which there are not good analogs for wave 6.  However the same information should be covered in the above checks;


*private insurance?;
gen inspriv6=.;
gen insexch6=0;
replace inspriv6=1 if epins6==0 & inssp6 == 0; *no employer provided health insurance;
replace inspriv6=0 if HN023==0;
replace inspriv6=0 if HN001==1; * Covered by medicare; 
replace inspriv6=0 if HN005==1; * covered by medicaid, covered;
replace inspriv6=0 if epins6==1;
replace inspriv6=1 if HN037_1 == 1 | HN037_2 == 1 | HN037_3 == 1 | HN037_1 == 4 | HN037_2 == 4 | HN037_3 == 4;
replace inspriv6=0 if HN037_1 ~= 1 & HN037_2 ~= 1 & HN037_3 ~= 1 & HN037_1 ~= 4 & HN037_2 ~= 4 & HN037_3 ~= 4 & HN037_1 ~= . & HN037_2 ~= . & HN037_3 ~= .;
replace inspriv6=1 if (self==1) & (HN033_1==1|HN033_2==1|HN033_3==1); * self-employed;
replace inspriv6=0 if (self==0) & (HN033_1==1|HN033_2==1|HN033_3==1); * self-employed;

sum inspriv6;

replace epfr6=0 if epins6==0;
replace eprhi6=0 if epins6==0;
replace epsp6=0 if epins6==0;
replace inssp6=0 if epins6==0;
replace eprfr6=0 if epins6==0;


*FSK code to use their medigap definition;
gen mcare=1 if HN001==1;
replace mcare=0 if HN001~=1 & HN001<999999;
gen medicaid=1 if HN006==1;
replace medicaid=0 if HN006>1;
gen tri_care=1 if HN007==1;
replace tri_care=0 if HN007>1 & HN007<8;
gen medigap6=0 if mcare==1 & HN023==0;
replace medigap6=1 if mcare==1 & HN025_1==1 & (HN037_1==1 | HN037_1==2 | HN037_1==4 | HN037_1==7) ;
* treat as missing, those who have no medicare or are covered by medicaid or VA/CHAMPUS or;
* have employer-sponsored HI, or who have private insurance that they do not pay for;
replace medigap6=. if mcare==0 | medicaid==1 | tri_care==1  | HN039_1==3;
replace medigap6=. if mcare==1 & HN025_1==1 & (HN033_1==1 |HN034_1==1 | HN035_1==1 | HN036_1==1 | HN037_1==3) & medigap6==0;
replace medigap6=. if mcare==1 & HN023>0 & HN023<99 & HN025_1~=1;

summ medigap6 inspriv6;
tab medigap6 inspriv6, missing;
* FSK code;



keep HHID PN ins* ep* medc* medigap6; 
sum medc*;
sort HHID PN;
merge HHID PN using `saved'insure;
drop _merge;
summ;

sort HHID PN;
save `saved'insure, replace;
drop _all;


*********************WAVE VII**************************;

* quietly infile using `wave7d'H04J_R.dct;
use `wave7d'H04J_R;
gen self = .;
replace self = 1 if JJ021 == 2; *Note, if someone's secondary job isn't self employed, they will be missed, however most part time jobs don't include health insurance, so I don't think we'll have to worry about miscoding those people.;

gen temp=real(HHID);
drop HHID;
rename temp HHID;
gen temp=real(PN);
drop PN;
rename temp PN;
sort HHID PN;

keep self HHID PN;

save "`saved'selfemp", replace;
clear;

*quietly infile using `wave7d'H04N_R.dct;
use `wave7d'H04N_R;

gen temp=real(HHID);
drop HHID;
rename temp HHID;
gen temp=real(PN);
drop PN;
rename temp PN;
sort HHID PN;

merge HHID PN using `saved'selfemp;
drop _merge;

* medicare ? ;
gen medcare7=0;
replace medcare7=1 if JN001==1;

* government provided insurance?;
gen insgov7=0;
replace insgov7=1 if JN007==1; * Champus/Champva coverage question;
replace insgov7=2 if JN005==1|JN006==1; * Did you have Medicaid over the last 2 yrs?;
gen epins7=.;
gen epins7a=.;
gen epins7b=.;
gen epins7c=.;
gen epfr7=.;
gen epfr7a=.;
gen epfr7b=.;
gen epfr7c=.;
gen eprhi7=.;
gen eprfr7=.;
gen epsp7=.; 


*** QUESTION 1 ***;
*employer provided health insurance?; 
replace epins7a=0 if JN033_1==5|JN034_1==5|JN023==0;
replace epins7a=1 if JN033_1==1;
replace epins7a=0 if self==1; * self-employed;
replace epins7a=1 if JN034_1==1; 


* is the health insurance free (or reduced cost)?;
replace epfr7a=0 if JN039_1==1;
replace epfr7a=1 if JN039_1==2|JN039_1==3;
replace epfr7a=0 if self==1; * self-employed;
replace epfr7a=0 if JN036_1==5|JN036_1==8; * no employer-provided insurance;
replace epfr7a=0 if JN035_1==1; * obtain employer-provided insurance from spouse;
replace epfr7a=0 if epins7a==0; * no employer-provided insurance; * maybe unnecessary;

*** QUESTION 2 ***;
*employer provided health insurance?; 
replace epins7b=0 if JN033_2==5|JN034_2==5|JN023<2;
replace epins7b=1 if JN033_2==1; 
replace epins7b=0 if self==1; * self-employed; 
replace epins7b=1 if JN034_2==1; 

* is the health insurance free (or reduced cost)?;
replace epfr7b=0 if JN039_2==1;
replace epfr7b=1 if JN039_2==2|JN039_2==3;
replace epfr7b=0 if self==1; * self-employed;
replace epfr7b=0 if JN036_2==5|JN036_2==8; * no employer-provided insurance;
replace epfr7b=0 if JN035_2==1; * obtain employer-provided insurance from spouse;
replace epfr7b=0 if epins7b==0; * no employer-provided insurance; * maybe unnecessary;

*** QUESTION 3 ***;
*employer provided health insurance?; 
replace epins7c=0 if JN033_3==5|JN034_3==5|JN023<3;
replace epins7c=1 if JN033_3==1;
replace epins7c=0 if self==1; * self-employed;
replace epins7c=1 if JN034_3==1; 

* is the health insurance free (or reduced cost)?;
replace epfr7c=0 if JN039_3==1;
replace epfr7c=1 if JN039_3==2|JN039_3==3;
replace epfr7c=0 if self==1; * self-employed;
replace epfr7c=0 if JN036_3==5|JN036_3==8; * no employer-provided insurance;
replace epfr7c=0 if JN035_3==1; * obtain employer-provided insurance from spouse;
replace epfr7c=0 if epins7c==0; * no employer-provided insurance; * maybe unnecessary;

***consolidate***;
replace epins7 = 1 if (epins7a == 1 | epins7b == 1 | epins7c == 1);

tab epins7;

replace epfr7 = 1 if (epfr7a == 1 | epfr7b == 1 | epfr7c == 1);
replace epins7 = 0 if (epins7a == 0 & epins7b == 0 & epins7c == 0);

tab epins7;

replace epfr7 = 0 if (epfr7a == 0 & epfr7b == 0 & epfr7c == 0);


* is the spouse be covered by the employer-provided insurance?;
gen t2 = real(JN049_1a);
drop JN049_1a;
rename t2 JN049_1a;
gen t2 = real(JN049_1b);
drop JN049_1b;
rename t2 JN049_1b;
gen t2 = real(JN049_1c);
drop JN049_1c;
rename t2 JN049_1c;
gen t2 = real(JN049_1d);
drop JN049_1d;
rename t2 JN049_1d;
gen t2 = real(JN049_1e);
drop JN049_1e;
rename t2 JN049_1e;
gen t2 = real(JN049_1f);
drop JN049_1f;
rename t2 JN049_1f;

gen t2 = real(JN049_2a);
drop JN049_2a;
rename t2 JN049_2a;
gen t2 = real(JN049_2b);
drop JN049_2b;
rename t2 JN049_2b;
gen t2 = real(JN049_2c);
drop JN049_2c;
rename t2 JN049_2c;
gen t2 = real(JN049_2d);
drop JN049_2d;
rename t2 JN049_2d;
gen t2 = real(JN049_3a);
drop JN049_3a;
rename t2 JN049_3a;
gen t2 = real(JN049_3b);
drop JN049_3b;
rename t2 JN049_3b;
gen t2 = real(JN049_3c);
drop JN049_3c;
rename t2 JN049_3c;
gen t2 = real(JN049_3d);
drop JN049_3d;
rename t2 JN049_3d;

replace epsp7=1 if JN049_1a==991 | JN049_1b==991 | JN049_1c==991 | JN049_1d==991 | JN049_1e==991 | JN049_1f==991;
replace epsp7=1 if JN049_2a==991 | JN049_2b==991 | JN049_2c==991 | JN049_2d==991;
replace epsp7=1 if JN049_3a==991 | JN049_3b==991 | JN049_3c==991 | JN049_3d==991;

replace epsp7=0 if JN049_1a~=991 & JN049_1b~=991 & JN049_1c~=991 & JN049_1d~=991 & JN049_1e~=991 & JN049_1f~=991 & JN049_2a~=991 & JN049_2b~=991 & JN049_2c~=991 & JN049_2d~=991 & JN049_3a~=991 & JN049_3b~=991 & JN049_3c~=991 & JN049_3d~=991;

replace epsp7=. if (JN049_1a==999 | JN049_1a == .) & (JN049_1b==999 | JN049_1b==. ) & (JN049_1c==999 | JN049_1c==.) & (JN049_1d==999 | JN049_1d==.) & (JN049_1e==999 | JN049_1e==.) & (JN049_1f==999 | JN049_1f==.) & (JN049_2a==999 | JN049_2a==.) & (JN049_2b==999 | JN049_2b==.) & (JN049_2c==999 | JN049_2c==.) & (JN049_2d==999 | JN049_2d==.) & (JN049_3a==999 | JN049_3a==.) & (JN049_3b==999 | JN049_3b==.) & (JN049_3c==999 | JN049_3c==.) & (JN049_3d==999 | JN049_3d==.);
* re-set value from 0 to missing for "RF" and "INAP" cases;



* The following is for re-setting value from missing to 0 for "INAP" cases for JN049_1a-3d;
 
replace epsp7=0 if self==1; * self-employed;
replace epsp7=0 if epins7 ~=1; * no employer-provided insurance; 
replace epsp7=0 if JN035_1==1; * obtain employer-provided insurance from spouse;
replace epsp7=0 if JN035_2==1; * obtain employer-provided insurance from spouse;
replace epsp7=0 if JN035_3==1; * obtain employer-provided insurance from spouse;
replace epsp7=0 if JN026_1==1; * plan letter=A;
replace epsp7=0 if JN048_1==5|JN048_1==8; * No one else is covered by the employer-provided insurance;
replace epsp7=0 if JN048_2==5|JN048_2==8;
replace epsp7=0 if JN048_3==5|JN048_3==8;

* get employer-provided insurance from spouse's firm ( as opposed to own firm);
gen inssp7=.;


*replace inssp7=0 if JN023==0|epins7==1|(JN035_1==5 & JN036_1==5);
*replace inssp7=0 if self==1 & JN033_1==1;
replace inssp7=0;
replace inssp7=. if JN035_1 == 8 | JN037_1 == 8 | JN035_1 == 9 | JN037_1 == 9;
replace inssp7 = 1 if JN035_1 == 1 | JN037_1 == 1; * spouse; 
replace inssp7 = 1 if JN035_2 == 1 | JN037_2 == 1; * spouse;  
replace inssp7 = 1 if JN035_3 == 1 | JN037_3 == 1; * spouse; 
replace epins7=1 if inssp7==1;

tab epins7;

sum inssp*;


* does employer provide retiree health insurance;
* note: JN60_1 asks about whether those over 65 can keep their employer provided coverage;
* think about what to do with this one;
replace eprhi7 = 1 if JN059_1 == 1 | JN060_1 == 1;
replace eprhi7 = 1 if JN059_2 == 1 | JN060_2 == 1;
replace eprhi7 = 1 if JN059_3 == 1 | JN060_3 == 1;
replace eprhi7=0 if epins7 == 0; * no employer-provided insurance;
replace eprhi7=0 if inssp7==1; * obtain employer-provided insurance from spouse;
replace eprhi7=0 if eprhi7==. & epins7~=.;
summ eprhi7;


* Will the insurance cover the spouse after retirement?; 
gen eprsp7=.;
replace eprsp7=1 if JN062_1==1 | JN063_1==1;
replace eprsp7=1 if JN062_2==1 | JN063_2==1;
replace eprsp7=1 if JN062_3==1 | JN063_3==1;
replace eprsp7=0 if self==1; * self-employed; 
replace eprsp7=0 if epins7==0; * no employer-provided insurance;
replace eprsp7=0 if inssp7==1; * get employer-provided insurance through spouse;
replace eprsp7=0 if eprsp7==. & (JN062_1~=8 |JN062_1~=9 |JN063_1~=8 | JN063_1~=9);

*Note, there are several "checkpoints" in wave 5 for which there are not good analogs for wave 7.  However the same information should be covered in the above checks;


*private insurance?;

gen inspriv7=0;
gen insexch7=0;
replace inspriv7=1 if epins7==0 & inssp7 == 0; *no employer provided health insurance;
replace inspriv7=0 if JN023==0;
replace inspriv7=0 if JN001==1; * Covered by medicare; 
replace inspriv7=0 if JN005==1; * covered by medicaid, covered;
replace inspriv7=0 if epins7==1;
replace inspriv7=1 if JN037_1 == 1 | JN037_2 == 1 | JN037_3 == 1 | JN037_1 == 4 | JN037_2 == 4 | JN037_3 == 4;
replace inspriv7=0 if JN037_1 ~= 1 & JN037_2 ~= 1 & JN037_3 ~= 1 & JN037_1 ~= 4 & JN037_2 ~= 4 & JN037_3 ~= 4 & JN037_1 ~= . & JN037_2 ~= . & JN037_3 ~= .;
replace inspriv7=1 if (self==1) & (JN033_1==1|JN033_2==1|JN033_3==1); * self-employed;
replace inspriv7=0 if (self==0) & (JN033_1==1|JN033_2==1|JN033_3==1); * self-employed;

sum inspriv7;


replace epfr7=0 if epins7==0;
replace eprhi7=0 if epins7==0;
replace epsp7=0 if epins7==0;
replace inssp7=0 if epins7==0;
replace eprfr7=0 if epins7==0;

*FSK code to use their medigap definition;
gen mcare=1 if JN001==1;
replace mcare=0 if JN001~=1 & JN001<999999;
gen medicaid=1 if JN006==1;
replace medicaid=0 if JN006>1;
gen tri_care=1 if JN007==1;
replace tri_care=0 if JN007>1 & JN007<8;
gen medigap7=0 if mcare==1 & JN023==0;
replace medigap7=1 if mcare==1 & JN025_1==1 & (JN037_1==1 | JN037_1==2 | JN037_1==4 | JN037_1==7) ;
* treat as missing, those who have no medicare or are covered by medicaid or VA/CHAMPUS or;
* have employer-sponsored HI, or who have private insurance that they do not pay for;
replace medigap7=. if mcare==0 | medicaid==1 | tri_care==1  | JN039_1==3;
replace medigap7=. if mcare==1 & JN025_1==1 & (JN033_1==1 |JN034_1==1 | JN035_1==1 | JN036_1==1 | JN037_1==3) & medigap7==0;
replace medigap7=. if mcare==1 & JN023>0 & JN023<99 & JN025_1~=1;
* FSK code;
keep HHID PN ins* ep* medc* medigap7; 
sum medc*;

sort HHID PN;
merge HHID PN using `saved'insure;
drop _merge;
summ;

sort HHID PN;
save `saved'insure, replace;
drop _all;



********************** AHEAD WAVE I ************************************;
clear;
set mem 300m;
use `aheadw1'br21;
*408C: Changed all letters in variable names to capitals to match new data file;
gen insgov1=.;
gen epins1=.;
gen inssp1=.;
gen epfr1=.;
gen eprfr1=.;
gen eprhi1=.;
gen eprsp1=.;
gen inspriv1=.;
gen insexch1=0;

* medicare;
gen medcare1=0;
replace medcare1=1 if V754==1;

* covered by government insurance or not?;
replace insgov1=1 if V1848==1; 
replace insgov1=0 if V1848==5; * can't differentiate "DK", "RF" and "NA";
replace insgov1=2 if V1838==1; * medicaid;
* Li's comment: Since we can't differentiate "DK", "RF" and "NA", there will be
too many missing values;

* no data about other variables available;
gen temp=real(HHID);
drop HHID;
gen HHID=temp;
drop temp;
gen temp=real(PN);
drop PN;
gen PN=temp;
drop temp;
keep HHID PN ins* ep* medc*;
sort HHID PN;
save `aheadw1'insure, replace; 
summ;

************************** AHEAD WAVE II ***************************;
clear;
set mem 300m;
* get medicare info;
*408C:replaced ahd2pr file (which no longer exists) with A95PR_R, the assumed new equivalent;
*use `aheadw2'ahd2pr;
use `aheadw2'A95PR_R;
gen temp=real(HHID);
drop HHID;
rename temp HHID;
gen temp=real(PN);
drop PN;
rename temp PN;
gen medcare2=0;
replace medcare2=1 if D126==1;
keep HHID PN medcare2;
sort HHID PN;
save `aheadw2'temp, replace;
drop _all;

*408C:replaced ahd2r (which no longer exists) with A95R_R, the assumed new equivalent;
*use `aheadw2'ahd2r;
use `aheadw2'A95R_R;
 gen temp=real(HHID);
drop HHID;
rename temp HHID;
gen temp=real(PN);
drop PN;
rename temp PN;
sort HHID PN;
merge HHID PN using `aheadw2'temp;
drop _merge;
gen insgov2=.;
gen epins2=.;
gen inssp2=.;
gen epfr2=.;
gen eprfr2=.;
gen eprhi2=.;
gen eprsp2=.;
gen inspriv2=.;


* covered by government insurance or not?;
replace insgov2=1 if D5175==1;
replace insgov2=0 if D5175==5|D5175==8; * "DK" and "NO";
* There are 25 "INAP" cases about which there is not information;
replace insgov2=2 if D5155==1|D5158==1|D5159==1|D5160==1|D5161==5|D5163==1|
D5164==1|D5165==5;

* Li's comment: For the following three variables, there are not enough 
information about "INAP" cases. Therefore, the inaccuracy may occur with about
1200 observations, about which we don't know why they are not applicable.
However, if the code-book is correct and the reasons behind "INAP" is correct, 
Which in most cases are, then the following re-coding is very accuracte;

********************************************************;
* Note: the stuff below looks like it needs a lot of cleaning;
* It looks like all the stuff below is for HMOs, although D5225;
* (non-govt insurance) exists.  What about non-HMO insurance?;
* I think coding variables as 0 if D5225M1==. generates a lot of miscodes;

* Do you have employer-provided insurance or not?;
replace epins2=0 if D5225M1==5|D5225M1==6|D5225M1==7| D5225M2==5|D5225M2==6|D5225M2==7|D5225M3==5|D5225M3==6|D5225M3==7; 
replace epins2=1 if D5225M1==1|D5225M1==2|D5225M1==3|D5225M1==4| D5225M2==1|D5225M2==2|D5225M2==3|D5225M2==4| D5225M3==1|D5225M3==2|D5225M3==3|D5225M3==4; 
replace epins2=0 if D5225M1==.; * "INAP" cases; 
replace epins2=. if D5214==9; * re-set value from 0 to missing for "RF" for  
D5214, which is about "Do you have other insurance than government insurance?";

* get employer-provided insurance through the spouse ( as opposed to yourself)?;
replace inssp2=0 if D5225M1==1|D5225M1==2|D5225M1==5|D5225M1==6|D5225M1==7| D5225M2==1|D5225M2==2|D5225M2==5|D5225M2==6|D5225M2==7| D5225M3==1|D5225M3==2|D5225M3==5|D5225M3==6|D5225M3==7; * own firm or someplace else; 
replace inssp2=1 if D5225M1==3|D5225M1==4|D5225M2==3|D5225M2==4|
D5225M3==3|D5225M3==4;
replace inssp2=0 if D5225M1==.; * "INAP" cases;
replace inssp2=0 if D5214==9; * re-set value from 0 to missing for "RF" for
D5214, which is about "Do you have other insurance than government insurance?";
* do you have private insurance ?
replace inspriv2=0 if D5225M1==1|D5225M1==2|D5225M1==3|D5225M1==4|D5225M1==7| D5225M2==1|D5225M2==2|D5225M2==3|D5225M2==4|D5225M2==7| D5225M3==1|D5225M3==2|D5225M3==3|D5225M3==4|D5225M3==7; * own firm or someplace else; 
replace inspriv2=1 if D5225M1==5|D5225M1==6|D5225M2==5|D5225M2==6|
D5225M3==5|D5225M3==6;
replace inspriv2=0 if D5225M1==.; * "INAP" cases;
replace inspriv2=0 if D5214==9; * re-set value from 0 to missing for "RF" for
D5214, which is about "Do you have other insurance than government insurance?";

* is the employer-provided insurance free (reduced cost)?;
replace epfr2=1 if D5226==2|D5226==3; 
replace epfr2=0 if D5226==1; * paid entirely by the respondent or the spouse; 
replace epfr2=0 if D5226==4; * paid by employer/union of ex-spouse or deceased spouse; * only 3 cases; 
replace epfr2=0 if D5226==5; * paid by Medicare/welfare/public assistance/other to move/recorded elsewhere;
replace epfr2=0 if D5226==7; * Paid in "other" ways; 
replace epfr2=0 if D5226==.; * "INAP" cases;
replace epfr2=. if D5214==9; * re-set value from 0 to missing for "RF" for
D5214, which is about "Do you have other insurance than government insurance?";
replace epfr2=0 if epins2==0; * no employer-provided insurance; 

* no data about the other variables available; 


keep HHID PN ins* ep* medc*;
sort HHID PN;
merge HHID PN using `aheadw1'insure;
drop _merge;

rename insgov1 igov1;
rename epins1 ep1;
rename inssp1 sp1;
rename epfr1 fr1;
rename eprfr1 rfr1; 

*408C:troubleshooting;
sum eprhi1;

rename eprhi1 epr1;
rename eprsp1 ersp1;
rename inspriv1 ipriv1;
rename medcare1 medc1;

rename insgov2 igov2;
rename epins2 ep2;
rename inssp2 sp2;
rename epfr2 fr2;
rename eprfr2 rfr2;
rename eprhi2 epr2;
rename eprsp2 ersp2;
rename inspriv2 ipriv2;
rename medcare2 medc2;
sort HHID PN;
save `aheadw2'insure, replace; 
summ;

* merge the AHEAD WAVE II insure.dta file to the HRS insure.dta file here;
clear;
set mem 300m;
use `saved'insure;
sort HHID PN;
merge HHID PN using `aheadw2'insure;
drop _merge;

replace insgov1=igov1 if insgov1==. & igov1~=.;
replace epins1=ep1 if epins1==. & ep1~=.;
replace inssp1=sp1 if inssp1==. & sp1~=.;
replace epfr1=fr1 if epfr1==. & fr1~=.;
replace eprfr1=rfr1 if eprfr1==. & rfr1~=.;
replace eprhi1=epr1 if eprhi1==. & epr1~=.;
replace eprsp1=ersp1 if eprsp1==. & ersp1~=.;
replace inspriv1=ipriv1 if inspriv1==. & ipriv1~=.;
replace medcare1=medc1 if medcare1==. & medc1~=.;

replace insgov2=igov2 if insgov2==. & igov2~=.;
replace epins2=ep2 if epins2==. & ep2~=.;
replace inssp2=sp2 if inssp2==. & sp2~=.;
replace epfr2=fr2 if epfr2==. & fr2~=.;
replace eprfr2=rfr2 if eprfr2==. & rfr2~=.;
tab eprhi2;
replace eprhi2=epr2 if eprhi2==. & epr2~=.;
tab eprhi2;
replace eprsp2=ersp2 if eprsp2==. & ersp2~=.;
replace inspriv2=ipriv2 if inspriv2==. & ipriv2~=.;
replace medcare2=medc2 if medcare2==. & medc2~=.;

drop igov* ep1 ep2 sp* fr* rfr* epr1 epr2 er* ipriv* medc1 medc2;

sort HHID PN;
save `saved'insure, replace;
summ;
*drop _all;
cap log close ;


***********************WAVE VIII********************************;

*quietly infile using `wave8d'H06J_R.dct;
use `wave8d'H06J_R;

gen self = .;
replace self = 1 if KJ021 == 2; *Note, if someone's secondary job isn't self employed, they will be missed, however most part time jobs don't include health insurance, so I don't think we'll have to worry about miscoding those people.;

gen temp=real(HHID);
drop HHID;
rename temp HHID;
gen temp=real(PN);
drop PN;
rename temp PN;
sort HHID PN;

keep self HHID PN;

save "`saved'selfemp", replace;
clear;

* quietly infile using `wave8d'H06N_R.dct;
use `wave8d'H06N_R;

gen temp=real(HHID);
drop HHID;
rename temp HHID;
gen temp=real(PN);
drop PN;
rename temp PN;
sort HHID PN;

merge HHID PN using `saved'selfemp;
drop _merge;


* medicare ? ;
gen medcare8=0;
replace medcare8=1 if KN001==1;

* government provided insurance?;
gen insgov8=0;
replace insgov8=1 if KN007==1; * Champus/Champva coverage question;
replace insgov8=2 if KN005==1|KN006==1; * Did you have Medicaid over the last 2 yrs?;
gen epins8=.;
gen epins8a=.;
gen epins8b=.;
gen epins8c=.;
gen epfr8=.;
gen epfr8a=.;
gen epfr8b=.;
gen epfr8c=.;
gen eprhi8=.;
gen eprfr8=.;
gen epsp8=.; 


*** QUESTION 1 ***;
*employer provided health insurance?; 
replace epins8a=0 if KN033_1==5|KN034_1==5|KN023==0;
replace epins8a=1 if KN033_1==1;
replace epins8a=0 if self==1; * self-employed;
replace epins8a=1 if KN034_1==1; 


* is the health insurance free (or reduced cost)?;
replace epfr8a=0 if KN039_1==1;
replace epfr8a=1 if KN039_1==2|KN039_1==3;
replace epfr8a=0 if self==1; * self-employed;
replace epfr8a=0 if KN036_1==5|KN036_1==8; * no employer-provided insurance;
replace epfr8a=0 if KN035_1==1; * obtain employer-provided insurance from spouse;
replace epfr8a=0 if epins8a==0; * no employer-provided insurance; * maybe unnecessary;

*** QUESTION 2 ***;
*employer provided health insurance?; 
replace epins8b=0 if KN033_2==5|KN034_2==5|KN023<2;
replace epins8b=1 if KN033_2==1; 
replace epins8b=0 if self==1; * self-employed; 
replace epins8b=1 if KN034_2==1; 

* is the health insurance free (or reduced cost)?;
replace epfr8b=0 if KN039_2==1;
replace epfr8b=1 if KN039_2==2|KN039_2==3;
replace epfr8b=0 if self==1; * self-employed;
replace epfr8b=0 if KN036_2==5|KN036_2==8; * no employer-provided insurance;
replace epfr8b=0 if KN035_2==1; * obtain employer-provided insurance from spouse;
replace epfr8b=0 if epins8b==0; * no employer-provided insurance; * maybe unnecessary;

*** QUESTION 3 ***;
*employer provided health insurance?; 
replace epins8c=0 if KN033_3==5|KN034_3==5|KN023<3;
replace epins8c=1 if KN033_3==1;
replace epins8c=0 if self==1; * self-employed;
replace epins8c=1 if KN034_3==1; 

* is the health insurance free (or reduced cost)?;
replace epfr8c=0 if KN039_3==1;
replace epfr8c=1 if KN039_3==2|KN039_3==3;
replace epfr8c=0 if self==1; * self-employed;
replace epfr8c=0 if KN036_3==5|KN036_3==8; * no employer-provided insurance;
replace epfr8c=0 if KN035_3==1; * obtain employer-provided insurance from spouse;
replace epfr8c=0 if epins8c==0; * no employer-provided insurance; * maybe unnecessary;

***consolidate***;
replace epins8 = 1 if (epins8a == 1 | epins8b == 1 | epins8c == 1);

tab epins8;

replace epfr8 = 1 if (epfr8a == 1 | epfr8b == 1 | epfr8c == 1);
replace epins8 = 0 if (epins8a == 0 & epins8b == 0 & epins8c == 0);

tab epins8;

replace epfr8 = 0 if (epfr8a == 0 & epfr8b == 0 & epfr8c == 0);

* is the spouse be covered by the employer-provided insurance?;
gen t2 = real(KN049_1A);
drop KN049_1A;
rename t2 KN049_1A;
gen t2 = real(KN049_1B);
drop KN049_1B;
rename t2 KN049_1B;
gen t2 = real(KN049_1C);
drop KN049_1C;
rename t2 KN049_1C;
gen t2 = real(KN049_1D);
drop KN049_1D;
rename t2 KN049_1D;
gen t2 = real(KN049_1E);
drop KN049_1E;
rename t2 KN049_1E;
gen t2 = real(KN049_1F);
drop KN049_1F;
rename t2 KN049_1F;

gen t2 = real(KN049_2A);
drop KN049_2A;
rename t2 KN049_2A;
gen t2 = real(KN049_2B);
drop KN049_2B;
rename t2 KN049_2B;
gen t2 = real(KN049_2C);
drop KN049_2C;
rename t2 KN049_2C;
gen t2 = real(KN049_2D);
drop KN049_2D;
rename t2 KN049_2D;
gen t2 = real(KN049_3A);
drop KN049_3A;
rename t2 KN049_3A;
gen t2 = real(KN049_3B);
drop KN049_3B;
rename t2 KN049_3B;
gen t2 = real(KN049_3C);
drop KN049_3C;
rename t2 KN049_3C;
gen t2 = real(KN049_3D);
drop KN049_3D;
rename t2 KN049_3D;

replace epsp8=1 if KN049_1A==991 | KN049_1B==991 | KN049_1C==991 | KN049_1D==991 | KN049_1E==991 | KN049_1F==991;
replace epsp8=1 if KN049_2A==991 | KN049_2B==991 | KN049_2C==991 | KN049_2D==991;
replace epsp8=1 if KN049_3A==991 | KN049_3B==991 | KN049_3C==991 | KN049_3D==991;

replace epsp8=0 if KN049_1A~=991 & KN049_1B~=991 & KN049_1C~=991 & KN049_1D~=991 & KN049_1E~=991 & KN049_1F~=991 & KN049_2A~=991 & KN049_2B~=991 & KN049_2C~=991 & KN049_2D~=991 & KN049_3A~=991 & KN049_3B~=991 & KN049_3C~=991 & KN049_3D~=991;

replace epsp8=. if (KN049_1A==999 | KN049_1A == .) & (KN049_1B==999 | KN049_1B==. ) & (KN049_1C==999 | KN049_1C==.) & (KN049_1D==999 | KN049_1D==.) & (KN049_1E==999 | KN049_1E==.) & (KN049_1F==999 | KN049_1F==.) & (KN049_2A==999 | KN049_2A==.) & (KN049_2B==999 | KN049_2B==.) & (KN049_2C==999 | KN049_2C==.) & (KN049_2D==999 | KN049_2D==.) & (KN049_3A==999 | KN049_3A==.) & (KN049_3B==999 | KN049_3B==.) & (KN049_3C==999 | KN049_3C==.) & (KN049_3D==999 | KN049_3D==.);
* re-set value from 0 to missing for "RF" and "INAP" cases;

* The following is for re-setting value from missing to 0 for "INAP" cases for KN049_1A-3D;
 
replace epsp8=0 if self==1; * self-employed;
replace epsp8=0 if epins8 ~=1; * no employer-provided insurance; 
replace epsp8=0 if KN035_1==1; * obtain employer-provided insurance from spouse;
replace epsp8=0 if KN035_2==1; * obtain employer-provided insurance from spouse;
replace epsp8=0 if KN035_3==1; * obtain employer-provided insurance from spouse;




replace epsp8=0 if KN048_1==5|KN048_1==8; * No one else is covered by the employer-provided insurance;
replace epsp8=0 if KN048_2==5|KN048_2==8;
replace epsp8=0 if KN048_3==5|KN048_3==8;



* get employer-provided insurance from spouse's firm ( as opposed to own firm);
gen inssp8=.;


*replace inssp8=0 if KN023==0|epins8==1|(KN035_1==5 & KN036_1==5);
*replace inssp8=0 if self==1 & KN033_1==1;
replace inssp8=0;
replace inssp8=. if KN035_1 == 8 | KN036_1 == 8 | KN035_1 == 9 | KN036_1 == 9;
replace inssp8 = 1 if KN035_1 == 1 | KN036_1 == 1; * spouse; 
replace inssp8 = 1 if KN035_2 == 1 | KN036_2 == 1; * spouse;  
replace inssp8 = 1 if KN035_3 == 1 | KN036_3 == 1; * spouse; 
replace epins8=1 if inssp8==1;

tab epins8;

sum inssp*;



* does employer provide retiree health insurance;
* note: KN60_1 asks about whether those over 65 can keep their employer provided coverage;
* think about what to do with this one;
replace eprhi8 = 1 if KN059_1 == 1 | KN060_1 == 1;
replace eprhi8 = 1 if KN059_2 == 1 | KN060_2 == 1;
replace eprhi8 = 1 if KN059_3 == 1 | KN060_3 == 1;
replace eprhi8=0 if epins8 == 0; * no employer-provided insurance;
replace eprhi8=0 if inssp8==1; * obtain employer-provided insurance from spouse;
replace eprhi8=0 if eprhi8==. & epins8~=.;
summ eprhi8;



* Will the insurance cover the spouse after retirement?; 
gen eprsp8=.;
replace eprsp8=1 if KN062_1==1 | KN063_1==1;
replace eprsp8=1 if KN062_2==1 | KN063_2==1;
replace eprsp8=1 if KN062_3==1 | KN063_3==1;
replace eprsp8=0 if self==1; * self-employed; 
replace eprsp8=0 if epins8==0; * no employer-provided insurance;
replace eprsp8=0 if inssp8==1; * get employer-provided insurance through spouse;
replace eprsp8=0 if eprsp8==. & (KN062_1~=8 |KN062_1~=9 |KN063_1~=8 | KN063_1~=9);

*Note, there are several "checkpoints" in wave 5 for which there are not good analogs for wave 8.  However the same information should be covered in the above checks;


*private insurance?;

gen inspriv8=0;
gen insexch8=0;
replace inspriv8=1 if epins8==0 & inssp8 == 0; *no employer provided health insurance;
replace inspriv8=0 if KN023==0;
replace inspriv8=0 if KN001==1; * Covered by medicare; 
replace inspriv8=0 if KN005==1; * covered by medicaid, covered;
replace inspriv8=0 if epins8==1;
replace inspriv8=1 if KN037_1 == 1 | KN037_2 == 1 | KN037_3 == 1 | KN037_1 == 4 | KN037_2 == 4 | KN037_3 == 4;
replace inspriv8=0 if KN037_1 ~= 1 & KN037_2 ~= 1 & KN037_3 ~= 1 & KN037_1 ~= 4 & KN037_2 ~= 4 & KN037_3 ~= 4 & KN037_1 ~= . & KN037_2 ~= . & KN037_3 ~= .;
replace inspriv8=1 if (self==1) & (KN033_1==1|KN033_2==1|KN033_3==1); * self-employed;
replace inspriv8=0 if (self==0) & (KN033_1==1|KN033_2==1|KN033_3==1); * self-employed;

sum inspriv8;

replace epfr8=0 if epins8==0;
replace eprhi8=0 if epins8==0;
replace epsp8=0 if epins8==0;
replace inssp8=0 if epins8==0;
replace eprfr8=0 if epins8==0;

*FSK code to use their medigap definition;
gen mcare=1 if KN001==1;
replace mcare=0 if KN001~=1 & KN001<999999;
gen medicaid=1 if KN006==1;
replace medicaid=0 if KN006>1;
gen tri_care=1 if KN007==1;
replace tri_care=0 if KN007>1 & KN007<8;
gen medigap8=0 if mcare==1 & KN023==0;
replace medigap8=1 if mcare==1 & KN025_1==1 & (KN037_1==1 | KN037_1==2 | KN037_1==4 | KN037_1==7) ;
* treat as missing, those who have no medicare or are covered by medicaid or VA/CHAMPUS or;
* have employer-sponsored HI, or who have private insurance that they do not pay for;
replace medigap8=. if mcare==0 | medicaid==1 | tri_care==1  | KN039_1==3;
replace medigap8=. if mcare==1 & KN025_1==1 & (KN033_1==1 |KN034_1==1 | KN035_1==1 | KN036_1==1 | KN037_1==3) & medigap8==0;
replace medigap8=. if mcare==1 & KN023>0 & KN023<99 & KN025_1~=1;
* FSK code;
keep HHID PN ins* ep* medc* medigap8; 
sum medc*;

sort HHID PN;
merge HHID PN using `saved'insure;
drop _merge;
summ;

sort HHID PN;
save `saved'insure, replace;
drop _all;



***********************WAVE IX********************************;

*quietly infile using `wave9d'H08J_R.dct;
use `wave9d'H08J_R;

gen self = .;
replace self = 1 if LJ021 == 2; *Note, if someone's secondary job isn't self employed, they will be missed, however most part time jobs don't include health insurance, so I don't think we'll have to worry about miscoding those people.;

gen temp=real(HHID);
drop HHID;
rename temp HHID;
gen temp=real(PN);
drop PN;
rename temp PN;
sort HHID PN;

keep self HHID PN;

save "`saved'selfemp", replace;
clear;

* quietly infile using `wave9d'H08N_R.dct;
use `wave9d'H08N_R;

gen temp=real(HHID);
drop HHID;
rename temp HHID;
gen temp=real(PN);
drop PN;
rename temp PN;
sort HHID PN;

merge HHID PN using `saved'selfemp;
drop _merge;


* medicare ? ;
gen medcare9=0;
replace medcare9=1 if LN001==1;

* government provided insurance?;
gen insgov9=0;
replace insgov9=1 if LN007==1; * Champus/Champva coverage question;
replace insgov9=2 if LN005==1|LN006==1; * Did you have Medicaid over the last 2 yrs?;
gen epins9=.;
gen epins9a=.;
gen epins9b=.;
gen epins9c=.;
gen epfr9=.;
gen epfr9a=.;
gen epfr9b=.;
gen epfr9c=.;
gen eprhi9=.;
gen eprfr9=.;
gen epsp9=.; 


*** QUESTION 1 ***;
*employer provided health insurance?; 
replace epins9a=0 if LN033_1==5|LN034_1==5|LN023==0;
replace epins9a=1 if LN033_1==1;
replace epins9a=0 if self==1; * self-employed;
replace epins9a=1 if LN034_1==1; 


* is the health insurance free (or reduced cost)?;
replace epfr9a=0 if LN039_1==1;
replace epfr9a=1 if LN039_1==2|LN039_1==3;
replace epfr9a=0 if self==1; * self-employed;
replace epfr9a=0 if LN036_1==5|LN036_1==8; * no employer-provided insurance;
replace epfr9a=0 if LN035_1==1; * obtain employer-provided insurance from spouse;
replace epfr9a=0 if epins9a==0; * no employer-provided insurance; * maybe unnecessary;

*** QUESTION 2 ***;
*employer provided health insurance?; 
replace epins9b=0 if LN033_2==5|LN034_2==5|LN023<2;
replace epins9b=1 if LN033_2==1; 
replace epins9b=0 if self==1; * self-employed; 
replace epins9b=1 if LN034_2==1; 

* is the health insurance free (or reduced cost)?;
replace epfr9b=0 if LN039_2==1;
replace epfr9b=1 if LN039_2==2|LN039_2==3;
replace epfr9b=0 if self==1; * self-employed;
replace epfr9b=0 if LN036_2==5|LN036_2==8; * no employer-provided insurance;
replace epfr9b=0 if LN035_2==1; * obtain employer-provided insurance from spouse;
replace epfr9b=0 if epins9b==0; * no employer-provided insurance; * maybe unnecessary;

*** QUESTION 3 ***;
*employer provided health insurance?; 
replace epins9c=0 if LN033_3==5|LN034_3==5|LN023<3;
replace epins9c=1 if LN033_3==1;
replace epins9c=0 if self==1; * self-employed;
replace epins9c=1 if LN034_3==1; 

* is the health insurance free (or reduced cost)?;
replace epfr9c=0 if LN039_3==1;
replace epfr9c=1 if LN039_3==2|LN039_3==3;
replace epfr9c=0 if self==1; * self-employed;
replace epfr9c=0 if LN036_3==5|LN036_3==8; * no employer-provided insurance;
replace epfr9c=0 if LN035_3==1; * obtain employer-provided insurance from spouse;
replace epfr9c=0 if epins9c==0; * no employer-provided insurance; * maybe unnecessary;

***consolidate***;
replace epins9 = 1 if (epins9a == 1 | epins9b == 1 | epins9c == 1);

tab epins9;

replace epfr9 = 1 if (epfr9a == 1 | epfr9b == 1 | epfr9c == 1);
replace epins9 = 0 if (epins9a == 0 & epins9b == 0 & epins9c == 0);

tab epins9;

replace epfr9 = 0 if (epfr9a == 0 & epfr9b == 0 & epfr9c == 0);

* is the spouse be covered by the employer-provided insurance?;
gen t2 = real(LN049_1A);
drop LN049_1A;
rename t2 LN049_1A;
gen t2 = real(LN049_1B);
drop LN049_1B;
rename t2 LN049_1B;
gen t2 = real(LN049_1C);
drop LN049_1C;
rename t2 LN049_1C;
gen t2 = real(LN049_1D);
drop LN049_1D;
rename t2 LN049_1D;
gen t2 = real(LN049_1E);
drop LN049_1E;
rename t2 LN049_1E;
gen t2 = real(LN049_1F);
drop LN049_1F;
rename t2 LN049_1F;

gen t2 = real(LN049_2A);
drop LN049_2A;
rename t2 LN049_2A;
gen t2 = real(LN049_2B);
drop LN049_2B;
rename t2 LN049_2B;
gen t2 = real(LN049_2C);
drop LN049_2C;
rename t2 LN049_2C;
gen t2 = real(LN049_2D);
drop LN049_2D;
rename t2 LN049_2D;
gen t2 = real(LN049_3A);
drop LN049_3A;
rename t2 LN049_3A;
gen t2 = real(LN049_3B);
drop LN049_3B;
rename t2 LN049_3B;
gen t2 = real(LN049_3C);
drop LN049_3C;
rename t2 LN049_3C;
gen t2 = real(LN049_3D);
drop LN049_3D;
rename t2 LN049_3D;

replace epsp9=1 if LN049_1A==991 | LN049_1B==991 | LN049_1C==991 | LN049_1D==991 | LN049_1E==991 | LN049_1F==991;
replace epsp9=1 if LN049_2A==991 | LN049_2B==991 | LN049_2C==991 | LN049_2D==991;
replace epsp9=1 if LN049_3A==991 | LN049_3B==991 | LN049_3C==991 | LN049_3D==991;

replace epsp9=0 if LN049_1A~=991 & LN049_1B~=991 & LN049_1C~=991 & LN049_1D~=991 & LN049_1E~=991 & LN049_1F~=991 & LN049_2A~=991 & LN049_2B~=991 & LN049_2C~=991 & LN049_2D~=991 & LN049_3A~=991 & LN049_3B~=991 & LN049_3C~=991 & LN049_3D~=991;

replace epsp9=. if (LN049_1A==999 | LN049_1A == .) & (LN049_1B==999 | LN049_1B==. ) & (LN049_1C==999 | LN049_1C==.) & (LN049_1D==999 | LN049_1D==.) & (LN049_1E==999 | LN049_1E==.) & (LN049_1F==999 | LN049_1F==.) & (LN049_2A==999 | LN049_2A==.) & (LN049_2B==999 | LN049_2B==.) & (LN049_2C==999 | LN049_2C==.) & (LN049_2D==999 | LN049_2D==.) & (LN049_3A==999 | LN049_3A==.) & (LN049_3B==999 | LN049_3B==.) & (LN049_3C==999 | LN049_3C==.) & (LN049_3D==999 | LN049_3D==.);
* re-set value from 0 to missing for "RF" and "INAP" cases;

* The following is for re-setting value from missing to 0 for "INAP" cases for LN049_1A-3D;
 
replace epsp9=0 if self==1; * self-employed;
replace epsp9=0 if epins9 ~=1; * no employer-provided insurance; 
replace epsp9=0 if LN035_1==1; * obtain employer-provided insurance from spouse;
replace epsp9=0 if LN035_2==1; * obtain employer-provided insurance from spouse;
replace epsp9=0 if LN035_3==1; * obtain employer-provided insurance from spouse;




replace epsp9=0 if LN048_1==5|LN048_1==8; * No one else is covered by the employer-provided insurance;
replace epsp9=0 if LN048_2==5|LN048_2==8;
replace epsp9=0 if LN048_3==5|LN048_3==8;



* get employer-provided insurance from spouse's firm ( as opposed to own firm);
gen inssp9=.;


*replace inssp9=0 if LN023==0|epins9==1|(LN035_1==5 & LN036_1==5);
*replace inssp9=0 if self==1 & LN033_1==1;
replace inssp9=0;
replace inssp9=. if LN035_1 == 8 | LN036_1 == 8 | LN035_1 == 9 | LN036_1 == 9;
replace inssp9 = 1 if LN035_1 == 1 | LN036_1 == 1; * spouse; 
replace inssp9 = 1 if LN035_2 == 1 | LN036_2 == 1; * spouse;  
replace inssp9 = 1 if LN035_3 == 1 | LN036_3 == 1; * spouse; 
replace epins9=1 if inssp9==1;

tab epins9;

sum inssp*;



* does employer provide retiree health insurance;
* note: LN60_1 asks about whether those over 65 can keep their employer provided coverage;
* think about what to do with this one;
replace eprhi9 = 1 if LN059_1 == 1 | LN060_1 == 1;
replace eprhi9 = 1 if LN059_2 == 1 | LN060_2 == 1;
replace eprhi9 = 1 if LN059_3 == 1 | LN060_3 == 1;
replace eprhi9=0 if epins9 == 0; * no employer-provided insurance;
replace eprhi9=0 if inssp9==1; * obtain employer-provided insurance from spouse;
replace eprhi9=0 if eprhi9==. & epins9~=.;
summ eprhi9;



* Will the insurance cover the spouse after retirement?; 
gen eprsp9=.;
replace eprsp9=1 if LN062_1==1 | LN063_1==1;
replace eprsp9=1 if LN062_2==1 | LN063_2==1;
replace eprsp9=1 if LN062_3==1 | LN063_3==1;
replace eprsp9=0 if self==1; * self-employed; 
replace eprsp9=0 if epins9==0; * no employer-provided insurance;
replace eprsp9=0 if inssp9==1; * get employer-provided insurance through spouse;
replace eprsp9=0 if eprsp9==. & (LN062_1~=8 |LN062_1~=9 |LN063_1~=8 | LN063_1~=9);

*Note, there are several "checkpoints" in wave 5 for which there are not good analogs for wave 9.  However the same information should be covered in the above checks;


*private insurance?;
gen inspriv9=0;
gen insexch9=0;
replace inspriv9=1 if epins9==0 & inssp9 == 0; *no employer provided health insurance;
replace inspriv9=0 if LN023==0;
replace inspriv9=0 if LN001==1; * Covered by medicare; 
replace inspriv9=0 if LN005==1; * covered by medicaid, covered;
replace inspriv9=0 if epins9==1;
replace inspriv9=1 if LN037_1 == 1 | LN037_2 == 1 | LN037_3 == 1 | LN037_1 == 4 | LN037_2 == 4 | LN037_3 == 4;
replace inspriv9=0 if LN037_1 ~= 1 & LN037_2 ~= 1 & LN037_3 ~= 1 & LN037_1 ~= 4 & LN037_2 ~= 4 & LN037_3 ~= 4 & LN037_1 ~= . & LN037_2 ~= . & LN037_3 ~= .;
replace inspriv9=1 if (self==1) & (LN033_1==1|LN033_2==1|LN033_3==1); * self-employed;
replace inspriv9=0 if (self==0) & (LN033_1==1|LN033_2==1|LN033_3==1); * self-employed;

sum inspriv9;




replace epfr9=0 if epins9==0;
replace eprhi9=0 if epins9==0;
replace epsp9=0 if epins9==0;
replace inssp9=0 if epins9==0;
replace eprfr9=0 if epins9==0;

*FSK code to use their medigap definition;
gen mcare=1 if LN001==1;
replace mcare=0 if LN001~=1 & LN001<999999;
gen medicaid=1 if LN006==1;
replace medicaid=0 if LN006>1;
gen tri_care=1 if LN007==1;
replace tri_care=0 if LN007>1 & LN007<8;
gen medigap9=0 if mcare==1 & LN023==0;
replace medigap9=1 if mcare==1 & LN025_1==1 & (LN037_1==1 | LN037_1==2 | LN037_1==4 | LN037_1==7) ;
* treat as missing, those who have no medicare or are covered by medicaid or VA/CHAMPUS or;
* have employer-sponsored HI, or who have private insurance that they do not pay for;
replace medigap9=. if mcare==0 | medicaid==1 | tri_care==1  | LN039_1==3;
replace medigap9=. if mcare==1 & LN025_1==1 & (LN033_1==1 |LN034_1==1 | LN035_1==1 | LN036_1==1 | LN037_1==3) & medigap9==0;
replace medigap9=. if mcare==1 & LN023>0 & LN023<99 & LN025_1~=1;
* FSK code;

keep HHID PN ins* ep* medc* medigap9; 
sum medc*;

sort HHID PN;
merge HHID PN using `saved'insure;
drop _merge;
summ;

sort HHID PN;
save `saved'insure, replace;
drop _all;

***********************WAVE X********************************;

*quietly infile using `wave10d'H10J_R.dct;
use `wave10d'H10J_R;

gen self = .;
replace self = 1 if MJ021 == 2; *Note, if someone's secondary job isn't self employed, they will be missed, however most part time jobs don't include health insurance, so I don't think we'll have to worry about miscoding those people.;

gen temp=real(HHID);
drop HHID;
rename temp HHID;
gen temp=real(PN);
drop PN;
rename temp PN;
sort HHID PN;

keep self HHID PN;

save "`saved'selfemp", replace;
clear;

* quietly infile using `wave10d'H10N_R.dct;
use `wave10d'H10N_R;

gen temp=real(HHID);
drop HHID;
rename temp HHID;
gen temp=real(PN);
drop PN;
rename temp PN;
sort HHID PN;

merge HHID PN using `saved'selfemp;
drop _merge;


* medicare ? ;
gen medcare10=0;
replace medcare10=1 if MN001==1;

* government provided insurance?;
gen insgov10=0;
replace insgov10=1 if MN007==1; * Champus/Champva coverage question;
replace insgov10=2 if MN005==1|MN006==1; * Did you have Medicaid over the last 2 yrs?;
gen epins10=.;
gen epins10a=.;
gen epins10b=.;
gen epins10c=.;
gen epfr10=.;
gen epfr10a=.;
gen epfr10b=.;
gen epfr10c=.;
gen eprhi10=.;
gen eprfr10=.;
gen epsp10=.; 


*** QUESTION 1 ***;
*employer provided health insurance?; 
replace epins10a=0 if MN033_1==5|MN034_1==5|MN023==0;
replace epins10a=1 if MN033_1==1;
replace epins10a=0 if self==1; * self-employed;
replace epins10a=1 if MN034_1==1; 


* is the health insurance free (or reduced cost)?;
replace epfr10a=0 if MN039_1==1;
replace epfr10a=1 if MN039_1==2|MN039_1==3;
replace epfr10a=0 if self==1; * self-employed;
replace epfr10a=0 if MN036_1==5|MN036_1==8; * no employer-provided insurance;
replace epfr10a=0 if MN035_1==1; * obtain employer-provided insurance from spouse;
replace epfr10a=0 if epins10a==0; * no employer-provided insurance; * maybe unnecessary;

*** QUESTION 2 ***;
*employer provided health insurance?; 
replace epins10b=0 if MN033_2==5|MN034_2==5|MN023<2;
replace epins10b=1 if MN033_2==1; 
replace epins10b=0 if self==1; * self-employed; 
replace epins10b=1 if MN034_2==1; 

* is the health insurance free (or reduced cost)?;
replace epfr10b=0 if MN039_2==1;
replace epfr10b=1 if MN039_2==2|MN039_2==3;
replace epfr10b=0 if self==1; * self-employed;
replace epfr10b=0 if MN036_2==5|MN036_2==8; * no employer-provided insurance;
replace epfr10b=0 if MN035_2==1; * obtain employer-provided insurance from spouse;
replace epfr10b=0 if epins10b==0; * no employer-provided insurance; * maybe unnecessary;

*** QUESTION 3 ***;
*employer provided health insurance?; 
replace epins10c=0 if MN033_3==5|MN034_3==5|MN023<3;
replace epins10c=1 if MN033_3==1;
replace epins10c=0 if self==1; * self-employed;
replace epins10c=1 if MN034_3==1; 

* is the health insurance free (or reduced cost)?;
replace epfr10c=0 if MN039_3==1;
replace epfr10c=1 if MN039_3==2|MN039_3==3;
replace epfr10c=0 if self==1; * self-employed;
replace epfr10c=0 if MN036_3==5|MN036_3==8; * no employer-provided insurance;
replace epfr10c=0 if MN035_3==1; * obtain employer-provided insurance from spouse;
replace epfr10c=0 if epins10c==0; * no employer-provided insurance; * maybe unnecessary;

***consolidate***;
replace epins10 = 1 if (epins10a == 1 | epins10b == 1 | epins10c == 1);

tab epins10;

replace epfr10 = 1 if (epfr10a == 1 | epfr10b == 1 | epfr10c == 1);
replace epins10 = 0 if (epins10a == 0 & epins10b == 0 & epins10c == 0);

tab epins10;

replace epfr10 = 0 if (epfr10a == 0 & epfr10b == 0 & epfr10c == 0);

* is the spouse be covered by the employer-provided insurance?;
gen t2 = real(MN049_1A);
drop MN049_1A;
rename t2 MN049_1A;
gen t2 = real(MN049_1B);
drop MN049_1B;
rename t2 MN049_1B;
gen t2 = real(MN049_1C);
drop MN049_1C;
rename t2 MN049_1C;
gen t2 = real(MN049_1D);
drop MN049_1D;
rename t2 MN049_1D;
gen t2 = real(MN049_1E);
drop MN049_1E;
rename t2 MN049_1E;
gen t2 = real(MN049_1F);
drop MN049_1F;
rename t2 MN049_1F;

gen t2 = real(MN049_2A);
drop MN049_2A;
rename t2 MN049_2A;
gen t2 = real(MN049_2B);
drop MN049_2B;
rename t2 MN049_2B;
gen t2 = real(MN049_2C);
drop MN049_2C;
rename t2 MN049_2C;
gen t2 = real(MN049_2D);
drop MN049_2D;
rename t2 MN049_2D;
gen t2 = real(MN049_3A);
drop MN049_3A;
rename t2 MN049_3A;
gen t2 = real(MN049_3B);
drop MN049_3B;
rename t2 MN049_3B;
gen t2 = real(MN049_3C);
drop MN049_3C;
rename t2 MN049_3C;
gen t2 = real(MN049_3D);
drop MN049_3D;
rename t2 MN049_3D;

replace epsp10=1 if MN049_1A==991 | MN049_1B==991 | MN049_1C==991 | MN049_1D==991 | MN049_1E==991 | MN049_1F==991;
replace epsp10=1 if MN049_2A==991 | MN049_2B==991 | MN049_2C==991 | MN049_2D==991;
replace epsp10=1 if MN049_3A==991 | MN049_3B==991 | MN049_3C==991 | MN049_3D==991;

replace epsp10=0 if MN049_1A~=991 & MN049_1B~=991 & MN049_1C~=991 & MN049_1D~=991 & MN049_1E~=991 & MN049_1F~=991 & MN049_2A~=991 & MN049_2B~=991 & MN049_2C~=991 & MN049_2D~=991 & MN049_3A~=991 & MN049_3B~=991 & MN049_3C~=991 & MN049_3D~=991;

replace epsp10=. if (MN049_1A==999 | MN049_1A == .) & (MN049_1B==999 | MN049_1B==. ) & (MN049_1C==999 | MN049_1C==.) & (MN049_1D==999 | MN049_1D==.) & (MN049_1E==999 | MN049_1E==.) & (MN049_1F==999 | MN049_1F==.) & (MN049_2A==999 | MN049_2A==.) & (MN049_2B==999 | MN049_2B==.) & (MN049_2C==999 | MN049_2C==.) & (MN049_2D==999 | MN049_2D==.) & (MN049_3A==999 | MN049_3A==.) & (MN049_3B==999 | MN049_3B==.) & (MN049_3C==999 | MN049_3C==.) & (MN049_3D==999 | MN049_3D==.);
* re-set value from 0 to missing for "RF" and "INAP" cases;

* The following is for re-setting value from missing to 0 for "INAP" cases for MN04_1A-3D;
 
replace epsp10=0 if self==1; * self-employed;
replace epsp10=0 if epins10 ~=1; * no employer-provided insurance; 
replace epsp10=0 if MN035_1==1; * obtain employer-provided insurance from spouse;
replace epsp10=0 if MN035_2==1; * obtain employer-provided insurance from spouse;
replace epsp10=0 if MN035_3==1; * obtain employer-provided insurance from spouse;




replace epsp10=0 if MN048_1==5|MN048_1==8; * No one else is covered by the employer-provided insurance;
replace epsp10=0 if MN048_2==5|MN048_2==8;
replace epsp10=0 if MN048_3==5|MN048_3==8;



* get employer-provided insurance from spouse's firm ( as opposed to own firm);
gen inssp10=.;


*replace inssp10=0 if MN023==0|epins10==1|(MN035_1==5 & MN036_1==5);
*replace inssp10=0 if self==1 & MN033_1==1;
replace inssp10=0;
replace inssp10=. if MN035_1 == 8 | MN036_1 == 8 | MN035_1 == 9 | MN036_1 == 9;
replace inssp10 = 1 if MN035_1 == 1 | MN036_1 == 1; * spouse; 
replace inssp10 = 1 if MN035_2 == 1 | MN036_2 == 1; * spouse;  
replace inssp10 = 1 if MN035_3 == 1 | MN036_3 == 1; * spouse; 
replace epins10=1 if inssp10==1;

tab epins10;

sum inssp*;



* does employer provide retiree health insurance;
* note: MN60_1 asks about whether those over 65 can keep their employer provided coverage;
* think about what to do with this one;
replace eprhi10 = 1 if MN059_1 == 1 | MN060_1 == 1;
replace eprhi10 = 1 if MN059_2 == 1 | MN060_2 == 1;
replace eprhi10 = 1 if MN059_3 == 1 | MN060_3 == 1;
replace eprhi10=0 if epins10 == 0; * no employer-provided insurance;
replace eprhi10=0 if inssp10==1; * obtain employer-provided insurance from spouse;
replace eprhi10=0 if eprhi10==. & epins10~=.;
summ eprhi10;



* Will the insurance cover the spouse after retirement?; 
gen eprsp10=.;
replace eprsp10=1 if MN062_1==1 | MN063_1==1;
replace eprsp10=1 if MN062_2==1 | MN063_2==1;
replace eprsp10=1 if MN062_3==1 | MN063_3==1;
replace eprsp10=0 if self==1; * self-employed; 
replace eprsp10=0 if epins10==0; * no employer-provided insurance;
replace eprsp10=0 if inssp10==1; * get employer-provided insurance through spouse;
replace eprsp10=0 if eprsp10==. & (MN062_1~=8 |MN062_1~=9 |MN063_1~=8 | MN063_1~=9);

*Note, there are several "checkpoints" in wave 5 for which there are not good analogs for wave 10.  However the same information should be covered in the above checks;


*private insurance?;
gen inspriv10=0;
gen insexch10=0;
replace inspriv10=1 if epins10==0 & inssp10 == 0; *no employer provided health insurance;
replace inspriv10=0 if MN023==0;
replace inspriv10=0 if MN001==1; * Covered by medicare; 
replace inspriv10=0 if MN005==1; * covered by medicaid, covered;
replace inspriv10=0 if epins10==1;
replace inspriv10=1 if MN037_1 == 1 | MN037_2 == 1 | MN037_3 == 1 | MN037_1 == 4 | MN037_2 == 4 | MN037_3 == 4;
replace inspriv10=0 if MN037_1 ~= 1 & MN037_2 ~= 1 & MN037_3 ~= 1 & MN037_1 ~= 4 & MN037_2 ~= 4 & MN037_3 ~= 4 & MN037_1 ~= . & MN037_2 ~= . & MN037_3 ~= .;
replace inspriv10=1 if (self==1) & (MN033_1==1|MN033_2==1|MN033_3==1); * self-employed;
replace inspriv10=0 if (self==0) & (MN033_1==1|MN033_2==1|MN033_3==1); * self-employed;

sum inspriv10;




replace epfr10=0 if epins10==0;
replace eprhi10=0 if epins10==0;
replace epsp10=0 if epins10==0;
replace inssp10=0 if epins10==0;
replace eprfr10=0 if epins10==0;

*FSK code to use their medigap definition;
gen mcare=1 if MN001==1;
replace mcare=0 if MN001~=1 & MN001<999999;
gen medicaid=1 if MN006==1;
replace medicaid=0 if MN006>1;
gen tri_care=1 if MN007==1;
replace tri_care=0 if MN007>1 & MN007<8;
gen medigap10=0 if mcare==1 & MN023==0;
replace medigap10=1 if mcare==1 & MN025_1==1 & (MN037_1==1 | MN037_1==2 | MN037_1==4 | MN037_1==7) ;
* treat as missing, those who have no medicare or are covered by medicaid or VA/CHAMPUS or;
* have employer-sponsored HI, or who have private insurance that they do not pay for;
replace medigap10=. if mcare==0 | medicaid==1 | tri_care==1  | MN039_1==3;
replace medigap10=. if mcare==1 & MN025_1==1 & (MN033_1==1 |MN034_1==1 | MN035_1==1 | MN036_1==1 | MN037_1==3) & medigap10==0;
replace medigap10=. if mcare==1 & MN023>0 & MN023<99 & MN025_1~=1;
* FSK code;
keep HHID PN ins* ep* medc* medigap10; 
sum medc*;

sort HHID PN;
merge HHID PN using `saved'insure;
drop _merge;
summ;

sort HHID PN;
save `saved'insure, replace;
drop _all;





***********************WAVE XI********************************;


use `wave11d'H12J_R;

gen self = .;
replace self = 1 if NJ021 == 2; *Note, if someone's secondary job isn't self employed, they will be missed, however most part time jobs don't include health insurance, so I don't think we'll have to worry about miscoding those people.;

gen temp=real(HHID);
drop HHID;
rename temp HHID;
gen temp=real(PN);
drop PN;
rename temp PN;
sort HHID PN;

keep self HHID PN;

save "`saved'selfemp", replace;
clear;



use `wave11d'H12N_R;

gen temp=real(HHID);
drop HHID;
rename temp HHID;
gen temp=real(PN);
drop PN;
rename temp PN;
sort HHID PN;

merge HHID PN using `saved'selfemp;
drop _merge;


* medicare ? ;
gen medcare11=0;
replace medcare11=1 if NN001==1;

* government provided insurance?;
gen insgov11=0;
replace insgov11=1 if NN007==1; * Champus/Champva coverage question;
replace insgov11=2 if NN005==1|NN006==1; * Did you have Medicaid over the last 2 yrs?;
gen epins11=.;
gen epins11a=.;
gen epins11b=.;
gen epins11c=.;
gen epfr11=.;
gen epfr11a=.;
gen epfr11b=.;
gen epfr11c=.;
gen eprhi11=.;
gen eprfr11=.;
gen epsp11=.; 


*** QUESTION 1 ***;
*employer provided health insurance?; 
replace epins11a=0 if NN033_1==5|NN034_1==5|NN023==0; //check what 8 is;  
replace epins11a=1 if NN033_1==1;
replace epins11a=0 if self==1; * self-employed;
replace epins11a=1 if NN034_1==1; 


* is the health insurance free (or reduced cost)?;
replace epfr11a=0 if NN039_1==1;
replace epfr11a=1 if NN039_1==2|NN039_1==3;
replace epfr11a=0 if self==1; * self-employed;
replace epfr11a=0 if NN036_1==5|NN036_1==8; * no employer-provided insurance;
replace epfr11a=0 if NN035_1==1; * obtain employer-provided insurance from spouse;
replace epfr11a=0 if epins11a==0; * no employer-provided insurance; * maybe unnecessary;

*** QUESTION 2 ***;
*employer provided health insurance?; 
replace epins11b=0 if NN033_2==5|NN034_2==5|NN023<2;
replace epins11b=1 if NN033_2==1; 
replace epins11b=0 if self==1; * self-employed; 
replace epins11b=1 if NN034_2==1; 

* is the health insurance free (or reduced cost)?;
replace epfr11b=0 if NN039_2==1;
replace epfr11b=1 if NN039_2==2|NN039_2==3;
replace epfr11b=0 if self==1; * self-employed;
replace epfr11b=0 if NN036_2==5|NN036_2==8; * no employer-provided insurance;
replace epfr11b=0 if NN035_2==1; * obtain employer-provided insurance from spouse;
replace epfr11b=0 if epins11b==0; * no employer-provided insurance; * maybe unnecessary;

*** QUESTION 3 ***;
*employer provided health insurance?; 
replace epins11c=0 if NN033_3==5|NN034_3==5|NN023<3;
replace epins11c=1 if NN033_3==1;
replace epins11c=0 if self==1; * self-employed;
replace epins11c=1 if NN034_3==1; 

* is the health insurance free (or reduced cost)?;
replace epfr11c=0 if NN039_3==1;
replace epfr11c=1 if NN039_3==2|NN039_3==3;
replace epfr11c=0 if self==1; * self-employed;
replace epfr11c=0 if NN036_3==5|NN036_3==8; * no employer-provided insurance;
replace epfr11c=0 if NN035_3==1; * obtain employer-provided insurance from spouse;
replace epfr11c=0 if epins11c==0; * no employer-provided insurance; * maybe unnecessary;

***consolidate***;
replace epins11 = 1 if (epins11a == 1 | epins11b == 1 | epins11c == 1);

tab epins11;

replace epfr11 = 1 if (epfr11a == 1 | epfr11b == 1 | epfr11c == 1);
replace epins11 = 0 if (epins11a == 0 & epins11b == 0 & epins11c == 0);

tab epins11;

replace epfr11 = 0 if (epfr11a == 0 & epfr11b == 0 & epfr11c == 0);


**THIS BIT NEEDS FIXED"";


	*is the spouse be covered by the employer-provided insurance?;
	gen t2 = real(NN049_1A);
	drop NN049_1A;
	rename t2 NN049_1A;
	gen t2 = real(NN049_1B);
	drop NN049_1B;
	rename t2 NN049_1B;
	gen t2 = real(NN049_1C);
	drop NN049_1C;
	rename t2 NN049_1C;
	gen t2 = real(NN049_1D);
	drop NN049_1D;
	rename t2 NN049_1D;
	gen t2 = real(NN049_1E);
	drop NN049_1E;
	rename t2 NN049_1E;
	//gen t2 = real(NN049_1F);
	//drop NN049_1F;
	//rename t2 NN049_1F;

	gen t2 = real(NN049_2A);
	drop NN049_2A;
	rename t2 NN049_2A;
	gen t2 = real(NN049_2B);
	drop NN049_2B;
	rename t2 NN049_2B;
	gen t2 = real(NN049_2C);
	drop NN049_2C;
	rename t2 NN049_2C;
	gen t2 = real(NN049_2D);
	drop NN049_2D;
	rename t2 NN049_2D;
	gen t2 = real(NN049_3A);
	drop NN049_3A;
	rename t2 NN049_3A;
	gen t2 = real(NN049_3B);
	drop NN049_3B;
	rename t2 NN049_3B;
	gen t2 = real(NN049_3C);
	drop NN049_3C;
	rename t2 NN049_3C;
	gen t2 = real(NN049_3D);
	drop NN049_3D;
	rename t2 NN049_3D;

	// all of these vars only have 995: check why ;

	replace epsp11=1 if NN049_1A==991 | NN049_1B==991 | NN049_1C==991 | NN049_1D==991 | NN049_1E==991;  // | NN049_1F==991;
	replace epsp11=1 if NN049_2A==991 | NN049_2B==991 | NN049_2C==991 | NN049_2D==991;
	replace epsp11=1 if NN049_3A==991 | NN049_3B==991 | NN049_3C==991 | NN049_3D==991;

	replace epsp11=0 if NN049_1A~=991 & NN049_1B~=991 & NN049_1C~=991 & NN049_1D~=991 & NN049_1E~=991 & NN049_2A~=991 & NN049_2B~=991 & NN049_2C~=991 & NN049_2D~=991 & NN049_3A~=991 & NN049_3B~=991 & NN049_3C~=991 & NN049_3D~=991; // & NN049_1F~=991;

	replace epsp11=. if (NN049_1A==999 | NN049_1A == .) & (NN049_1B==999 | NN049_1B==. ) & (NN049_1C==999 | NN049_1C==.) & (NN049_1D==999 | NN049_1D==.) & (NN049_1E==999 | NN049_1E==.)  & (NN049_2A==999 | NN049_2A==.) & (NN049_2B==999 | NN049_2B==.) & (NN049_2C==999 | NN049_2C==.) & (NN049_2D==999 | NN049_2D==.) & (NN049_3A==999 | NN049_3A==.) & (NN049_3B==999 | NN049_3B==.) & (NN049_3C==999 | NN049_3C==.) & (NN049_3D==999 | NN049_3D==.); //& (NN049_1F==999 | NN049_1F==.);
	* re-set value from 0 to missing for "RF" and "INAP" cases;

	* The following is for re-setting value from missing to 0 for "INAP" cases for NN04_1A-3D;
	 
	replace epsp11=0 if self==1; * self-employed;
	replace epsp11=0 if epins11 ~=1; * no employer-provided insurance; 
	replace epsp11=0 if NN035_1==1; * obtain employer-provided insurance from spouse;
	replace epsp11=0 if NN035_2==1; * obtain employer-provided insurance from spouse;
	replace epsp11=0 if NN035_3==1; * obtain employer-provided insurance from spouse;




	replace epsp11=0 if NN048_1==5|NN048_1==8; * No one else is covered by the employer-provided insurance;
	replace epsp11=0 if NN048_2==5|NN048_2==8;
	replace epsp11=0 if NN048_3==5|NN048_3==8;



* get employer-provided insurance from spouse's firm ( as opposed to own firm);
gen inssp11=.;


*replace inssp11=0 if NN023==0|epins11==1|(NN035_1==5 & NN036_1==5);
*replace inssp11=0 if self==1 & NN033_1==1;
replace inssp11=0;
replace inssp11=. if NN035_1 == 8 | NN036_1 == 8 | NN035_1 == 9 | NN036_1 == 9;
replace inssp11 = 1 if NN035_1 == 1 | NN036_1 == 1; * spouse; 
replace inssp11 = 1 if NN035_2 == 1 | NN036_2 == 1; * spouse;  
replace inssp11 = 1 if NN035_3 == 1 | NN036_3 == 1; * spouse; 
replace epins11=1 if inssp11==1;

tab epins11;

sum inssp*;



* does employer provide retiree health insurance;
* note: NN60_1 asks about whether those over 65 can keep their employer provided coverage;
* think about what to do with this one;
replace eprhi11 = 1 if NN059_1 == 1 | NN060_1 == 1;
replace eprhi11 = 1 if NN059_2 == 1 | NN060_2 == 1;
replace eprhi11 = 1 if NN059_3 == 1 | NN060_3 == 1;
replace eprhi11=0 if epins11 == 0; * no employer-provided insurance;
replace eprhi11=0 if inssp11==1; * obtain employer-provided insurance from spouse;
replace eprhi11=0 if eprhi11==. & epins11~=.;
summ eprhi11;



* Will the insurance cover the spouse after retirement?; 
gen eprsp11=.;
replace eprsp11=1 if NN062_1==1 | NN063_1==1;
replace eprsp11=1 if NN062_2==1 | NN063_2==1;
replace eprsp11=1 if NN062_3==1 | NN063_3==1;
replace eprsp11=0 if self==1; * self-employed; 
replace eprsp11=0 if epins11==0; * no employer-provided insurance;
replace eprsp11=0 if inssp11==1; * get employer-provided insurance through spouse;
replace eprsp11=0 if eprsp11==. & (NN062_1~=8 |NN062_1~=9 |NN063_1~=8 | NN063_1~=9);

*Note, there are several "checkpoints" in wave 5 for which there are not good analogs for wave 11.  However the same information should be covered in the above checks;


*private insurance?;
gen inspriv11=0;
gen insexch11=0;
replace inspriv11=1 if epins11==0 & inssp11 == 0; *no employer provided health insurance;
replace inspriv11=0 if NN023==0;
replace inspriv11=0 if NN001==1; * Covered by medicare; 
replace inspriv11=0 if NN005==1; * covered by medicaid, covered;
replace inspriv11=0 if epins11==1;
replace inspriv11=1 if NN037_1 == 1 | NN037_2 == 1 | NN037_3 == 1 | NN037_1 == 4 | NN037_2 == 4 | NN037_3 == 4;
replace inspriv11=0 if NN037_1 ~= 1 & NN037_2 ~= 1 & NN037_3 ~= 1 & NN037_1 ~= 4 & NN037_2 ~= 4 & NN037_3 ~= 4 & NN037_1 ~= . & NN037_2 ~= . & NN037_3 ~= .;
replace inspriv11=1 if (self==1) & (NN033_1==1|NN033_2==1|NN033_3==1); * self-employed;
replace inspriv11=0 if (self==0) & (NN033_1==1|NN033_2==1|NN033_3==1); * self-employed;

sum inspriv11;




replace epfr11=0 if epins11==0;
replace eprhi11=0 if epins11==0;
replace epsp11=0 if epins11==0;
replace inssp11=0 if epins11==0;
replace eprfr11=0 if epins11==0;
*FSK code to use their medigap definition;
gen mcare=1 if NN001==1;
replace mcare=0 if NN001~=1 & NN001<999999;
gen medicaid=1 if NN006==1;
replace medicaid=0 if NN006>1;
gen tri_care=1 if NN007==1;
replace tri_care=0 if NN007>1 & NN007<8;
gen medigap11=0 if mcare==1 & NN023==0;
replace medigap11=1 if mcare==1 & NN025_1==1 & (NN037_1==1 | NN037_1==2 | NN037_1==4 | NN037_1==7) ;
* treat as missing, those who have no medicare or are covered by medicaid or VA/CHAMPUS or;
* have employer-sponsored HI, or who have private insurance that they do not pay for;
replace medigap11=. if mcare==0 | medicaid==1 | tri_care==1  | NN039_1==3;
replace medigap11=. if mcare==1 & NN025_1==1 & (NN033_1==1 |NN034_1==1 | NN035_1==1 | NN036_1==1 | NN037_1==3) & medigap11==0;
replace medigap11=. if mcare==1 & NN023>0 & NN023<99 & NN025_1~=1;
* FSK code;

keep HHID PN ins* ep* medc* medigap11; 
sum medc*;

sort HHID PN;
merge HHID PN using `saved'insure;
drop _merge;
summ;

sort HHID PN;
save `saved'insure, replace;



***********************WAVE 12********************************;


use `wave12d'H14J_R, clear;
# delimit cr

gen self = .
replace self = 1 if OJ021 == 2 
*Note, if someone's secondary job isn't self employed, they will be missed, however most part time jobs don't include health insurance, so I don't think we'll have to worry about miscoding those people.

gen temp=real(HHID)
drop HHID
rename temp HHID
gen temp=real(PN)
drop PN
rename temp PN
sort HHID PN

keep self HHID PN

save "`saved'selfemp", replace
clear


use `wave12d'H14N_R

gen temp=real(HHID)
drop HHID
rename temp HHID
gen temp=real(PN)
drop PN
rename temp PN
sort HHID PN

merge HHID PN using `saved'selfemp
drop _merge



gen medcare12=0
replace medcare12=1 if ON001==1


gen insgov12=0
replace insgov12=1 if ON007==1 
* Champus/Champva coverage question
replace insgov12=2 if ON005==1|ON006==1 
* Did you have Medicaid over the last 2 yrs?
gen epins12=.
gen epins12a=.
gen epins12b=.
gen epins12c=.
gen epfr12=.
gen epfr12a=.
gen epfr12b=.
gen epfr12c=.
gen eprhi12=.
gen eprfr12=.
gen epsp12=. 



replace epins12a=0 if ON033_1==5|ON034_1==5|ON023==0
replace epins12a=1 if ON033_1==1
replace epins12a=0 if self==1 
* self-employed
replace epins12a=1 if ON034_1==1 


* is the health insurance free (or reduced cost)?
*replace epfr12a=0 if ON039_1==1
*replace epfr12a=1 if ON039_1==2|ON039_1==3
replace epfr12a=0 if self==1 
* self-employed
replace epfr12a=0 if ON036_1==5|ON036_1==8 
* no employer-provided insurance
replace epfr12a=0 if ON035_1==1 
* obtain employer-provided insurance from spouse
replace epfr12a=0 if epins12a==0 
* no employer-provided insurance * maybe unnecessary

*** QUESTION 2 ***
*employer provided health insurance? 
replace epins12b=0 if ON033_2==5|ON034_2==5|ON023<2
replace epins12b=1 if ON033_2==1 
replace epins12b=0 if self==1 
* self-employed 
replace epins12b=1 if ON034_2==1 

* is the health insurance free (or reduced cost)?
*replace epfr12b=0 if ON039_2==1
*replace epfr12b=1 if ON039_2==2|ON039_2==3
replace epfr12b=0 if self==1 
* self-employed
replace epfr12b=0 if ON036_2==5|ON036_2==8
 * no employer-provided insurance
replace epfr12b=0 if ON035_2==1 
* obtain employer-provided insurance from spouse
replace epfr12b=0 if epins12b==0 
* no employer-provided insurance * maybe unnecessary

*** QUESTION 3 ***
*employer provided health insurance? 
replace epins12c=0 if ON033_3==5|ON034_3==5|ON023<3
replace epins12c=1 if ON033_3==1
replace epins12c=0 if self==1
 * self-employed
replace epins12c=1 if ON034_3==1 

* is the health insurance free (or reduced cost)?
*replace epfr12c=0 if ON039_3==1
*replace epfr12c=1 if ON039_3==2|ON039_3==3
replace epfr12c=0 if self==1
 * self-employed
replace epfr12c=0 if ON036_3==5|ON036_3==8 
* no employer-provided insurance
replace epfr12c=0 if ON035_3==1 
* obtain employer-provided insurance from spouse
replace epfr12c=0 if epins12c==0 
* no employer-provided insurance  maybe unnecessary

***consolidate***
replace epins12 = 1 if (epins12a == 1 | epins12b == 1 | epins12c == 1)

tab epins12

replace epfr12 = 1 if (epfr12a == 1 | epfr12b == 1 | epfr12c == 1)
replace epins12 = 0 if (epins12a == 0 & epins12b == 0 & epins12c == 0)

tab epins12

replace epfr12 = 0 if (epfr12a == 0 & epfr12b == 0 & epfr12c == 0)

* is the spouse be covered by the employer-provided insurance?
gen t2 = real(ON049_1A)
drop ON049_1A
rename t2 ON049_1A
gen t2 = real(ON049_1B)
drop ON049_1B
rename t2 ON049_1B
gen t2 = real(ON049_1C)
drop ON049_1C
rename t2 ON049_1C
gen t2 = real(ON049_1D)
drop ON049_1D
rename t2 ON049_1D
gen t2 = real(ON049_1E)
drop ON049_1E
rename t2 ON049_1E
gen t2 = real(ON049_1F)
drop ON049_1F
rename t2 ON049_1F

gen t2 = real(ON049_2A)
drop ON049_2A
rename t2 ON049_2A
gen t2 = real(ON049_2B)
drop ON049_2B
rename t2 ON049_2B
gen t2 = real(ON049_2C)
drop ON049_2C
rename t2 ON049_2C
gen t2 = real(ON049_2D)
drop ON049_2D
rename t2 ON049_2D
gen t2 = real(ON049_3A)
drop ON049_3A
rename t2 ON049_3A
gen t2 = real(ON049_3B)
drop ON049_3B
rename t2 ON049_3B
gen t2 = real(ON049_3C)
drop ON049_3C
rename t2 ON049_3C
gen t2 = real(ON049_3D)
drop ON049_3D
rename t2 ON049_3D

replace epsp12=1 if ON049_1A==991 | ON049_1B==991 | ON049_1C==991 | ON049_1D==991 | ON049_1E==991 | ON049_1F==991
replace epsp12=1 if ON049_2A==991 | ON049_2B==991 | ON049_2C==991 | ON049_2D==991
replace epsp12=1 if ON049_3A==991 | ON049_3B==991 | ON049_3C==991 | ON049_3D==991

replace epsp12=0 if ON049_1A~=991 & ON049_1B~=991 & ON049_1C~=991 & ON049_1D~=991 & ON049_1E~=991 & ON049_1F~=991 & ON049_2A~=991 & ON049_2B~=991 & ON049_2C~=991 & ON049_2D~=991 & ON049_3A~=991 & ON049_3B~=991 & ON049_3C~=991 & ON049_3D~=991

replace epsp12=. if (ON049_1A==999 | ON049_1A == .) & (ON049_1B==999 | ON049_1B==. ) & (ON049_1C==999 | ON049_1C==.) & (ON049_1D==999 | ON049_1D==.) & (ON049_1E==999 | ON049_1E==.) & (ON049_1F==999 | ON049_1F==.) & (ON049_2A==999 | ON049_2A==.) & (ON049_2B==999 | ON049_2B==.) & (ON049_2C==999 | ON049_2C==.) & (ON049_2D==999 | ON049_2D==.) & (ON049_3A==999 | ON049_3A==.) & (ON049_3B==999 | ON049_3B==.) & (ON049_3C==999 | ON049_3C==.) & (ON049_3D==999 | ON049_3D==.)
* re-set value from 0 to missing for "RF" and "INAP" cases

* The following is for re-setting value from missing to 0 for "INAP" cases for ON04_1A-3D
 
replace epsp12=0 if self==1 
* self-employed
replace epsp12=0 if epins12 ~=1 
* no employer-provided insurance 
replace epsp12=0 if ON035_1==1 
* obtain employer-provided insurance from spouse
replace epsp12=0 if ON035_2==1 

* obtain employer-provided insurance from spouse
replace epsp12=0 if ON035_3==1 
* obtain employer-provided insurance from spouse




replace epsp12=0 if ON048_1==5|ON048_1==8
 * No one else is covered by the employer-provided insurance
replace epsp12=0 if ON048_2==5|ON048_2==8
replace epsp12=0 if ON048_3==5|ON048_3==8



* get employer-provided insurance from spouse's firm ( as opposed to own firm)
gen inssp12=.


*replace inssp12=0 if ON023==0|epins12==1|(ON035_1==5 & ON036_1==5)
*replace inssp12=0 if self==1 & ON033_1==1
replace inssp12=0
replace inssp12=. if ON035_1 == 8 | ON036_1 == 8 | ON035_1 == 9 | ON036_1 == 9
replace inssp12 = 1 if ON035_1 == 1 | ON036_1 == 1 
* spouse 
replace inssp12 = 1 if ON035_2 == 1 | ON036_2 == 1 

* spouse  
replace inssp12 = 1 if ON035_3 == 1 | ON036_3 == 1 
* spouse 
replace epins12=1 if inssp12==1

tab epins12

sum inssp*



* does employer provide retiree health insurance
* note: ON60_1 asks about whether those over 65 can keep their employer provided coverage
* think about what to do with this one
replace eprhi12 = 1 if ON059_1 == 1 | ON060_1 == 1
replace eprhi12 = 1 if ON059_2 == 1 | ON060_2 == 1
replace eprhi12 = 1 if ON059_3 == 1 | ON060_3 == 1
replace eprhi12=0 if epins12 == 0 
* no employer-provided insurance
replace eprhi12=0 if inssp12==1 
* obtain employer-provided insurance from spouse
replace eprhi12=0 if eprhi12==. & epins12~=.
summ eprhi12



* Will the insurance cover the spouse after retirement? 
gen eprsp12=.
replace eprsp12=1 if ON062_1==1 | ON063_1==1
replace eprsp12=1 if ON062_2==1 | ON063_2==1
replace eprsp12=1 if ON062_3==1 | ON063_3==1
replace eprsp12=0 if self==1 
* self-employed 
replace eprsp12=0 if epins12==0 
* no employer-provided insurance
replace eprsp12=0 if inssp12==1 
* get employer-provided insurance through spouse
replace eprsp12=0 if eprsp12==. & (ON062_1~=8 |ON062_1~=9 |ON063_1~=8 | ON063_1~=9)

*Note, there are several "checkpoints" in wave 5 for which there are not good analogs for wave 12.  However the same information should be covered in the above checks


*private insurance?
gen inspriv12=0
gen insexch12=0
replace insexch12 = 1 if ON037_1 == 5 | ON037_2 == 5 | ON037_3 == 5

replace inspriv12=1 if epins12==0 & inssp12 == 0 
*no employer provided health insurance
replace inspriv12=0 if ON023==0
replace inspriv12=0 if ON001==1 
* Covered by medicare 
replace inspriv12=0 if ON005==1 
* covered by medicaid, covered
replace inspriv12=0 if epins12==1
replace inspriv12=1 if ON037_1 == 1 | ON037_2 == 1 | ON037_3 == 1 | ON037_1 == 4 | ON037_2 == 4 | ON037_3 == 4 | ON037_1 == 5 | ON037_2 == 5 | ON037_3 == 5
replace inspriv12=0 if ON037_1 ~= 1 & ON037_2 ~= 1 & ON037_3 ~= 1 & ON037_1 ~= 4 & ON037_2 ~= 4 & ON037_3 ~= 4 & ON037_1 ~= 5 & ON037_2 ~= 5 & ON037_3 ~= 5 & ON037_1 ~= . & ON037_2 ~= . & ON037_3 ~= .

replace inspriv12=1 if (self==1) & (ON033_1==1|ON033_2==1|ON033_3==1) 
* self-employed
replace inspriv12=0 if (self==0) & (ON033_1==1|ON033_2==1|ON033_3==1) 
* self-employed

sum inspriv12




replace epfr12=0 if epins12==0
replace eprhi12=0 if epins12==0
replace epsp12=0 if epins12==0
replace inssp12=0 if epins12==0
replace eprfr12=0 if epins12==0
keep HHID PN ins* ep* medc* 
sum medc*

sort HHID PN
merge HHID PN using `saved'insure
drop _merge
summ

sort HHID PN
save `saved'insure, replace
sum *11 *12
drop _all



***********************WAVE 13********************************



use `wave13d'H16J_R, clear

gen self = .
replace self = 1 if PJ021 == 2 
*Note, if someone's secondary job isn't self employed, they will be missed, however most part time jobs don't include health insurance, so I don't think we'll have to worry about miscoding those people.

gen temp=real(HHID)
drop HHID
rename temp HHID
gen temp=real(PN)
drop PN
rename temp PN
sort HHID PN

keep self HHID PN

save "`saved'selfemp", replace
clear


use `wave13d'H16N_R

gen temp=real(HHID)
drop HHID
rename temp HHID
gen temp=real(PN)
drop PN
rename temp PN
sort HHID PN

merge HHID PN using `saved'selfemp
drop _merge



gen medcare13=0
replace medcare13=1 if PN001==1


gen insgov13=0
replace insgov13=1 if PN007==1 
* Champus/Champva coverage question
replace insgov13=2 if PN005==1|PN006==1 
* Did you have Medicaid over the last 2 yrs?
gen epins13=.
gen epins13a=.
gen epins13b=.
gen epins13c=.
gen epfr13=.
gen epfr13a=.
gen epfr13b=.
gen epfr13c=.
gen eprhi13=.
gen eprfr13=.
gen epsp13=. 



replace epins13a=0 if PN033_1==5|PN034_1==5|PN023==0
replace epins13a=1 if PN033_1==1
replace epins13a=0 if self==1 
* self-employed
replace epins13a=1 if PN034_1==1 


* is the health insurance free (or reduced cost)?
*replace epfr13a=0 if PN039_1==1
*replace epfr13a=1 if PN039_1==2|PN039_1==3
replace epfr13a=0 if self==1 
* self-employed
replace epfr13a=0 if PN036_1==5|PN036_1==8 
* no employer-provided insurance
replace epfr13a=0 if PN035_1==1 
* obtain employer-provided insurance from spouse
replace epfr13a=0 if epins13a==0 
* no employer-provided insurance * maybe unnecessary

*** QUESTION 2 ***
*employer provided health insurance? 
replace epins13b=0 if PN033_2==5|PN034_2==5|PN023<2
replace epins13b=1 if PN033_2==1 
replace epins13b=0 if self==1 
* self-employed 
replace epins13b=1 if PN034_2==1 

* is the health insurance free (or reduced cost)?
*replace epfr13b=0 if PN039_2==1
*replace epfr13b=1 if PN039_2==2|PN039_2==3
replace epfr13b=0 if self==1 
* self-employed
replace epfr13b=0 if PN036_2==5|PN036_2==8
 * no employer-provided insurance
replace epfr13b=0 if PN035_2==1 
* obtain employer-provided insurance from spouse
replace epfr13b=0 if epins13b==0 
* no employer-provided insurance * maybe unnecessary

*** QUESTION 3 ***
*employer provided health insurance? 
replace epins13c=0 if PN033_3==5|PN034_3==5|PN023<3
replace epins13c=1 if PN033_3==1
replace epins13c=0 if self==1
 * self-employed
replace epins13c=1 if PN034_3==1 

* is the health insurance free (or reduced cost)?
*replace epfr13c=0 if PN039_3==1
*replace epfr13c=1 if PN039_3==2|PN039_3==3
replace epfr13c=0 if self==1
 * self-employed
replace epfr13c=0 if PN036_3==5|PN036_3==8 
* no employer-provided insurance
replace epfr13c=0 if PN035_3==1 
* obtain employer-provided insurance from spouse
replace epfr13c=0 if epins13c==0 
* no employer-provided insurance  maybe unnecessary

***consolidate***
replace epins13 = 1 if (epins13a == 1 | epins13b == 1 | epins13c == 1)

tab epins13

replace epfr13 = 1 if (epfr13a == 1 | epfr13b == 1 | epfr13c == 1)
replace epins13 = 0 if (epins13a == 0 & epins13b == 0 & epins13c == 0)

tab epins13

replace epfr13 = 0 if (epfr13a == 0 & epfr13b == 0 & epfr13c == 0)

* is the spouse be covered by the employer-provided insurance?
gen t2 = real(PN049_1A)
drop PN049_1A
rename t2 PN049_1A
gen t2 = real(PN049_1B)
drop PN049_1B
rename t2 PN049_1B
gen t2 = real(PN049_1C)
drop PN049_1C
rename t2 PN049_1C
gen t2 = real(PN049_1D)
drop PN049_1D
rename t2 PN049_1D
gen t2 = real(PN049_1E)
drop PN049_1E
rename t2 PN049_1E
gen t2 = real(PN049_1F)
drop PN049_1F
rename t2 PN049_1F

gen t2 = real(PN049_2A)
drop PN049_2A
rename t2 PN049_2A
gen t2 = real(PN049_2B)
drop PN049_2B
rename t2 PN049_2B
gen t2 = real(PN049_2C)
drop PN049_2C
rename t2 PN049_2C
gen t2 = real(PN049_2D)
drop PN049_2D
rename t2 PN049_2D
gen t2 = real(PN049_3A)
drop PN049_3A
rename t2 PN049_3A
gen t2 = real(PN049_3B)
drop PN049_3B
rename t2 PN049_3B
gen t2 = real(PN049_3C)
drop PN049_3C
rename t2 PN049_3C
gen t2 = real(PN049_3D)
drop PN049_3D
rename t2 PN049_3D

replace epsp13=1 if PN049_1A==991 | PN049_1B==991 | PN049_1C==991 | PN049_1D==991 | PN049_1E==991 | PN049_1F==991
replace epsp13=1 if PN049_2A==991 | PN049_2B==991 | PN049_2C==991 | PN049_2D==991
replace epsp13=1 if PN049_3A==991 | PN049_3B==991 | PN049_3C==991 | PN049_3D==991

replace epsp13=0 if PN049_1A~=991 & PN049_1B~=991 & PN049_1C~=991 & PN049_1D~=991 & PN049_1E~=991 & PN049_1F~=991 & PN049_2A~=991 & PN049_2B~=991 & PN049_2C~=991 & PN049_2D~=991 & PN049_3A~=991 & PN049_3B~=991 & PN049_3C~=991 & PN049_3D~=991

replace epsp13=. if (PN049_1A==999 | PN049_1A == .) & (PN049_1B==999 | PN049_1B==. ) & (PN049_1C==999 | PN049_1C==.) & (PN049_1D==999 | PN049_1D==.) & (PN049_1E==999 | PN049_1E==.) & (PN049_1F==999 | PN049_1F==.) & (PN049_2A==999 | PN049_2A==.) & (PN049_2B==999 | PN049_2B==.) & (PN049_2C==999 | PN049_2C==.) & (PN049_2D==999 | PN049_2D==.) & (PN049_3A==999 | PN049_3A==.) & (PN049_3B==999 | PN049_3B==.) & (PN049_3C==999 | PN049_3C==.) & (PN049_3D==999 | PN049_3D==.)
* re-set value from 0 to missing for "RF" and "INAP" cases

* The following is for re-setting value from missing to 0 for "INAP" cases for ON04_1A-3D
 
replace epsp13=0 if self==1 
* self-employed
replace epsp13=0 if epins13 ~=1 
* no employer-provided insurance 
replace epsp13=0 if PN035_1==1 
* obtain employer-provided insurance from spouse
replace epsp13=0 if PN035_2==1 

* obtain employer-provided insurance from spouse
replace epsp13=0 if PN035_3==1 
* obtain employer-provided insurance from spouse




replace epsp13=0 if PN048_1==5|PN048_1==8
 * No one else is covered by the employer-provided insurance
replace epsp13=0 if PN048_2==5|PN048_2==8
replace epsp13=0 if PN048_3==5|PN048_3==8



* get employer-provided insurance from spouse's firm ( as opposed to own firm)
gen inssp13=.


*replace inssp13=0 if PN023==0|epins13==1|(PN035_1==5 & PN036_1==5)
*replace inssp13=0 if self==1 & PN033_1==1
replace inssp13=0
replace inssp13=. if PN035_1 == 8 | PN036_1 == 8 | PN035_1 == 9 | PN036_1 == 9
replace inssp13 = 1 if PN035_1 == 1 | PN036_1 == 1 
* spouse 
replace inssp13 = 1 if PN035_2 == 1 | PN036_2 == 1 

* spouse  
replace inssp13 = 1 if PN035_3 == 1 | PN036_3 == 1 
* spouse 
replace epins13=1 if inssp13==1

tab epins13

sum inssp*



* does employer provide retiree health insurance
* note: PN60_1 asks about whether those over 65 can keep their employer provided coverage
* think about what to do with this one
replace eprhi13 = 1 if PN059_1 == 1 | PN060_1 == 1
replace eprhi13 = 1 if PN059_2 == 1 | PN060_2 == 1
replace eprhi13 = 1 if PN059_3 == 1 | PN060_3 == 1
replace eprhi13=0 if epins13 == 0 
* no employer-provided insurance
replace eprhi13=0 if inssp13==1 
* obtain employer-provided insurance from spouse
replace eprhi13=0 if eprhi13==. & epins13~=.
summ eprhi13



* Will the insurance cover the spouse after retirement? 
gen eprsp13=.
replace eprsp13=1 if PN062_1==1 | PN063_1==1
replace eprsp13=1 if PN062_2==1 | PN063_2==1
replace eprsp13=1 if PN062_3==1 | PN063_3==1
replace eprsp13=0 if self==1 
* self-employed 
replace eprsp13=0 if epins13==0 
* no employer-provided insurance
replace eprsp13=0 if inssp13==1 
* get employer-provided insurance through spouse
replace eprsp13=0 if eprsp13==. & (PN062_1~=8 |PN062_1~=9 |PN063_1~=8 | PN063_1~=9)

*Note, there are several "checkpoints" in wave 5 for which there are not good analogs for wave 12.  However the same information should be covered in the above checks


*private insurance?
gen inspriv13=0
gen insexch13=0
* buy insurance from insurance exchange
replace insexch13 = 1 if PN037_1 == 5 | PN037_2 == 5 | PN037_3 == 5

replace inspriv13=1 if epins13==0 & inssp13 == 0 
*no employer provided health insurance
replace inspriv13=0 if PN023==0
replace inspriv13=0 if PN001==1 
* Covered by medicare 
replace inspriv13=0 if PN005==1 
* covered by medicaid, covered
replace inspriv13=0 if epins13==1
replace inspriv13=1 if PN037_1 == 1 | PN037_2 == 1 | PN037_3 == 1 | PN037_1 == 4 | PN037_2 == 4 | PN037_3 == 4 | PN037_1 == 5 | PN037_2 == 5 | PN037_3 == 5
replace inspriv13=0 if PN037_1 ~= 1 & PN037_2 ~= 1 & PN037_3 ~= 1 & PN037_1 ~= 4 & PN037_2 ~= 4 & PN037_3 ~= 4 & PN037_1 ~= 5 & PN037_2 ~= 5 & PN037_3 ~= 5 & PN037_1 ~= . & PN037_2 ~= . & PN037_3 ~= .
replace inspriv13=1 if (self==1) & (PN033_1==1|PN033_2==1|PN033_3==1) 
* self-employed
replace inspriv13=0 if (self==0) & (PN033_1==1|PN033_2==1|PN033_3==1) 
* self-employed

sum inspriv13




replace epfr13=0 if epins13==0
replace eprhi13=0 if epins13==0
replace epsp13=0 if epins13==0
replace inssp13=0 if epins13==0
replace eprfr13=0 if epins13==0
keep HHID PN ins* ep* medc* 
sum medc*

sort HHID PN
merge HHID PN using `saved'insure
drop _merge
summ

sort HHID PN
save `saved'insure, replace
sum *12 *13


************************************************ END WAVE 13

***********************WAVE 14********************************

use `wave14d'H18J_R, clear

gen self = .
replace self = 1 if QJ021 == 2 
*Note, if someone's secondary job isn't self employed, they will be missed, however most part time jobs don't include health insurance, so I don't think we'll have to worry about miscoding those people.

gen temp=real(hhid)
drop hhid
rename temp HHID
gen temp=real(pn)
drop pn
rename temp PN
sort HHID PN

keep self HHID PN

save "`saved'selfemp", replace
clear


use `wave14d'H18N_R

gen temp=real(hhid)
drop hhid
rename temp HHID
gen temp=real(pn)
drop pn
rename temp PN
sort HHID PN

merge HHID PN using `saved'selfemp
drop _merge



gen medcare14=0
replace medcare14=1 if QN001==1


gen insgov14=0
replace insgov14=1 if QN007==1 
* Champus/Champva coverage question
replace insgov14=2 if QN005==1|QN006==1 
* Did you have Medicaid over the last 2 yrs?
gen epins14=.
gen epins14a=.
gen epins14b=.
gen epins14c=.
gen epfr14=.
gen epfr14a=.
gen epfr14b=.
gen epfr14c=.
gen eprhi14=.
gen eprfr14=.
gen epsp14=. 



replace epins14a=0 if QN033_1==5|QN034_1==5|QN023==0
replace epins14a=1 if QN033_1==1
replace epins14a=0 if self==1 
* self-employed
replace epins14a=1 if QN034_1==1 


* is the health insurance free (or reduced cost)?
*replace epfr14a=0 if QN039_1==1
*replace epfr14a=1 if QN039_1==2|QN039_1==3
replace epfr14a=0 if self==1 
* self-employed
replace epfr14a=0 if QN036_1==5|QN036_1==8 
* no employer-provided insurance
replace epfr14a=0 if QN035_1==1 
* obtain employer-provided insurance from spouse
replace epfr14a=0 if epins14a==0 
* no employer-provided insurance * maybe unnecessary

*** QUESTION 2 ***
*employer provided health insurance? 
replace epins14b=0 if QN033_2==5|QN034_2==5|QN023<2
replace epins14b=1 if QN033_2==1 
replace epins14b=0 if self==1 
* self-employed 
replace epins14b=1 if QN034_2==1 

* is the health insurance free (or reduced cost)?
*replace epfr14b=0 if QN039_2==1
*replace epfr14b=1 if QN039_2==2|QN039_2==3
replace epfr14b=0 if self==1 
* self-employed
replace epfr14b=0 if QN036_2==5|QN036_2==8
 * no employer-provided insurance
replace epfr14b=0 if QN035_2==1 
* obtain employer-provided insurance from spouse
replace epfr14b=0 if epins14b==0 
* no employer-provided insurance * maybe unnecessary

*** QUESTION 3 ***
*employer provided health insurance? 
replace epins14c=0 if QN033_3==5|QN034_3==5|QN023<3
replace epins14c=1 if QN033_3==1
replace epins14c=0 if self==1
 * self-employed
replace epins14c=1 if QN034_3==1 

* is the health insurance free (or reduced cost)?
*replace epfr14c=0 if QN039_3==1
*replace epfr14c=1 if QN039_3==2|QN039_3==3
replace epfr14c=0 if self==1
 * self-employed
replace epfr14c=0 if QN036_3==5|QN036_3==8 
* no employer-provided insurance
replace epfr14c=0 if QN035_3==1 
* obtain employer-provided insurance from spouse
replace epfr14c=0 if epins14c==0 
* no employer-provided insurance  maybe unnecessary

***consolidate***
replace epins14 = 1 if (epins14a == 1 | epins14b == 1 | epins14c == 1)

tab epins14

replace epfr14 = 1 if (epfr14a == 1 | epfr14b == 1 | epfr14c == 1)
replace epins14 = 0 if (epins14a == 0 & epins14b == 0 & epins14c == 0)

tab epins14

replace epfr14 = 0 if (epfr14a == 0 & epfr14b == 0 & epfr14c == 0)

* is the spouse be covered by the employer-provided insurance?
gen t2 = real(QN049_1A)
drop QN049_1A
rename t2 QN049_1A
gen t2 = real(QN049_1B)
drop QN049_1B
rename t2 QN049_1B
gen t2 = real(QN049_1C)
drop QN049_1C
rename t2 QN049_1C
gen t2 = real(QN049_1D)
drop QN049_1D
rename t2 QN049_1D
gen t2 = real(QN049_1E)
drop QN049_1E
rename t2 QN049_1E
gen t2 = real(QN049_1F)
drop QN049_1F
rename t2 QN049_1F

gen t2 = real(QN049_2A)
drop QN049_2A
rename t2 QN049_2A
gen t2 = real(QN049_2B)
drop QN049_2B
rename t2 QN049_2B
gen t2 = real(QN049_2C)
drop QN049_2C
rename t2 QN049_2C
gen t2 = real(QN049_2D)
drop QN049_2D
rename t2 QN049_2D
gen t2 = real(QN049_3A)
drop QN049_3A
rename t2 QN049_3A
gen t2 = real(QN049_3B)
drop QN049_3B
rename t2 QN049_3B
gen t2 = real(QN049_3C)
drop QN049_3C
rename t2 QN049_3C
gen t2 = real(QN049_3D)
drop QN049_3D
rename t2 QN049_3D

replace epsp14=1 if QN049_1A==991 | QN049_1B==991 | QN049_1C==991 | QN049_1D==991 | QN049_1E==991 | QN049_1F==991
replace epsp14=1 if QN049_2A==991 | QN049_2B==991 | QN049_2C==991 | QN049_2D==991
replace epsp14=1 if QN049_3A==991 | QN049_3B==991 | QN049_3C==991 | QN049_3D==991

replace epsp14=0 if QN049_1A~=991 & QN049_1B~=991 & QN049_1C~=991 & QN049_1D~=991 & QN049_1E~=991 & QN049_1F~=991 & QN049_2A~=991 & QN049_2B~=991 & QN049_2C~=991 & QN049_2D~=991 & QN049_3A~=991 & QN049_3B~=991 & QN049_3C~=991 & QN049_3D~=991

replace epsp14=. if (QN049_1A==999 | QN049_1A == .) & (QN049_1B==999 | QN049_1B==. ) & (QN049_1C==999 | QN049_1C==.) & (QN049_1D==999 | QN049_1D==.) & (QN049_1E==999 | QN049_1E==.) & (QN049_1F==999 | QN049_1F==.) & (QN049_2A==999 | QN049_2A==.) & (QN049_2B==999 | QN049_2B==.) & (QN049_2C==999 | QN049_2C==.) & (QN049_2D==999 | QN049_2D==.) & (QN049_3A==999 | QN049_3A==.) & (QN049_3B==999 | QN049_3B==.) & (QN049_3C==999 | QN049_3C==.) & (QN049_3D==999 | QN049_3D==.)
* re-set value from 0 to missing for "RF" and "INAP" cases

* The following is for re-setting value from missing to 0 for "INAP" cases for ON04_1A-3D
 
replace epsp14=0 if self==1 
* self-employed
replace epsp14=0 if epins14 ~=1 
* no employer-provided insurance 
replace epsp14=0 if QN035_1==1 
* obtain employer-provided insurance from spouse
replace epsp14=0 if QN035_2==1 

* obtain employer-provided insurance from spouse
replace epsp14=0 if QN035_3==1 
* obtain employer-provided insurance from spouse




replace epsp14=0 if QN048_1==5|QN048_1==8
 * No one else is covered by the employer-provided insurance
replace epsp14=0 if QN048_2==5|QN048_2==8
replace epsp14=0 if QN048_3==5|QN048_3==8



* get employer-provided insurance from spouse's firm ( as opposed to own firm)
gen inssp14=.


*replace inssp14=0 if QN023==0|epins14==1|(QN035_1==5 & QN036_1==5)
*replace inssp14=0 if self==1 & QN033_1==1
replace inssp14=0
replace inssp14=. if QN035_1 == 8 | QN036_1 == 8 | QN035_1 == 9 | QN036_1 == 9
replace inssp14 = 1 if QN035_1 == 1 | QN036_1 == 1 
* spouse 
replace inssp14 = 1 if QN035_2 == 1 | QN036_2 == 1 

* spouse  
replace inssp14 = 1 if QN035_3 == 1 | QN036_3 == 1 
* spouse 
replace epins14=1 if inssp14==1

tab epins14

sum inssp*



* does employer provide retiree health insurance
* note: QN60_1 asks about whether those over 65 can keep their employer provided coverage
* think about what to do with this one
replace eprhi14 = 1 if QN059_1 == 1 | QN060_1 == 1
replace eprhi14 = 1 if QN059_2 == 1 | QN060_2 == 1
replace eprhi14 = 1 if QN059_3 == 1 | QN060_3 == 1
replace eprhi14=0 if epins14 == 0 
* no employer-provided insurance
replace eprhi14=0 if inssp14==1 
* obtain employer-provided insurance from spouse
replace eprhi14=0 if eprhi14==. & epins14~=.
summ eprhi14



* Will the insurance cover the spouse after retirement? 
gen eprsp14=.
replace eprsp14=1 if QN062_1==1 | QN063_1==1
replace eprsp14=1 if QN062_2==1 | QN063_2==1
replace eprsp14=1 if QN062_3==1 | QN063_3==1
replace eprsp14=0 if self==1 
* self-employed 
replace eprsp14=0 if epins14==0 
* no employer-provided insurance
replace eprsp14=0 if inssp14==1 
* get employer-provided insurance through spouse
replace eprsp14=0 if eprsp14==. & (QN062_1~=8 |QN062_1~=9 |QN063_1~=8 | QN063_1~=9)

*Note, there are several "checkpoints" in wave 5 for which there are not good analogs for wave 12.  However the same information should be covered in the above checks


*private insurance?
gen inspriv14=0
gen insexch14=0
* buy insurance from insurance exchange
replace insexch14 = 1 if QN037_1 == 5 | QN037_2 == 5 | QN037_3 == 5

replace inspriv14=1 if epins14==0 & inssp14 == 0 
*no employer provided health insurance
replace inspriv14=0 if QN023==0
replace inspriv14=0 if QN001==1 
* Covered by medicare 
replace inspriv14=0 if QN005==1 
* covered by medicaid, covered
replace inspriv14=0 if epins14==1
replace inspriv14=1 if QN037_1 == 1 | QN037_2 == 1 | QN037_3 == 1 | QN037_1 == 4 | QN037_2 == 4 | QN037_3 == 4 | QN037_1 == 5 | QN037_2 == 5 | QN037_3 == 5
replace inspriv14=0 if QN037_1 ~= 1 & QN037_2 ~= 1 & QN037_3 ~= 1 & QN037_1 ~= 4 & QN037_2 ~= 4 & QN037_3 ~= 4 & QN037_1 ~= 5 & QN037_2 ~= 5 & QN037_3 ~= 5 & QN037_1 ~= . & QN037_2 ~= . & QN037_3 ~= .
replace inspriv14=1 if (self==1) & (QN033_1==1|QN033_2==1|QN033_3==1) 
* self-employed
replace inspriv14=0 if (self==0) & (QN033_1==1|QN033_2==1|QN033_3==1) 
* self-employed

sum inspriv14




replace epfr14=0 if epins14==0
replace eprhi14=0 if epins14==0
replace epsp14=0 if epins14==0
replace inssp14=0 if epins14==0
replace eprfr14=0 if epins14==0
keep HHID PN ins* ep* medc* 
sum medc*

sort HHID PN
merge HHID PN using `saved'insure
drop _merge
summ

sort HHID PN
save `saved'insure, replace
sum *13 *14


************************************************ END WAVE 14

***********************WAVE 15********************************

if $INCLUDE2020 {

use `wave15d'H20J_R, clear

gen self = .
replace self = 1 if RJ021 == 2 
*Note, if someone's secondary job isn't self employed, they will be missed, however most part time jobs don't include health insurance, so I don't think we'll have to worry about miscoding those people.

gen temp=real(hhid)
drop hhid
rename temp HHID
gen temp=real(pn)
drop pn
rename temp PN
sort HHID PN


keep self HHID PN

save "`saved'selfemp", replace
clear


use `wave15d'H20N_R

gen temp=real(hhid)
drop hhid
rename temp HHID
gen temp=real(pn)
drop pn
rename temp PN
sort HHID PN

merge HHID PN using `saved'selfemp
drop _merge



gen medcare15=0
replace medcare15=1 if RN001==1


gen insgov15=0
replace insgov15=1 if RN007==1 
* Champus/Champva coverage question
replace insgov15=2 if RN005==1|RN006==1 
* Did you have Medicaid over the last 2 yrs?
gen epins15=.
gen epins15a=.
gen epins15b=.
gen epins15c=.
gen epfr15=.
gen epfr15a=.
gen epfr15b=.
gen epfr15c=.
gen eprhi15=.
gen eprfr15=.
gen epsp15=. 



replace epins15a=0 if RN033_1==5|RN034_1==5|RN023==0
replace epins15a=1 if RN033_1==1
replace epins15a=0 if self==1 
* self-employed
replace epins15a=1 if RN034_1==1 


* is the health insurance free (or reduced cost)?
*replace epfr15a=0 if RN039_1==1
*replace epfr15a=1 if RN039_1==2|RN039_1==3
replace epfr15a=0 if self==1 
* self-employed
replace epfr15a=0 if RN036_1==5|RN036_1==8 
* no employer-provided insurance
replace epfr15a=0 if RN035_1==1 
* obtain employer-provided insurance from spouse
replace epfr15a=0 if epins15a==0 
* no employer-provided insurance * maybe unnecessary

*** QUESTION 2 ***
*employer provided health insurance? 
replace epins15b=0 if RN033_2==5|RN034_2==5|RN023<2
replace epins15b=1 if RN033_2==1 
replace epins15b=0 if self==1 
* self-employed 
replace epins15b=1 if RN034_2==1 

* is the health insurance free (or reduced cost)?
*replace epfr15b=0 if RN039_2==1
*replace epfr15b=1 if RN039_2==2|RN039_2==3
replace epfr15b=0 if self==1 
* self-employed
replace epfr15b=0 if RN036_2==5|RN036_2==8
 * no employer-provided insurance
replace epfr15b=0 if RN035_2==1 
* obtain employer-provided insurance from spouse
replace epfr15b=0 if epins15b==0 
* no employer-provided insurance * maybe unnecessary

*** QUESTION 3 ***
*employer provided health insurance? 
replace epins15c=0 if RN033_3==5|RN034_3==5|RN023<3
replace epins15c=1 if RN033_3==1
replace epins15c=0 if self==1
 * self-employed
replace epins15c=1 if RN034_3==1 

* is the health insurance free (or reduced cost)?
*replace epfr15c=0 if RN039_3==1
*replace epfr15c=1 if RN039_3==2|RN039_3==3
replace epfr15c=0 if self==1
 * self-employed
replace epfr15c=0 if RN036_3==5|RN036_3==8 
* no employer-provided insurance
replace epfr15c=0 if RN035_3==1 
* obtain employer-provided insurance from spouse
replace epfr15c=0 if epins15c==0 
* no employer-provided insurance  maybe unnecessary

***consolidate***
replace epins15 = 1 if (epins15a == 1 | epins15b == 1 | epins15c == 1)

tab epins15

replace epfr15 = 1 if (epfr15a == 1 | epfr15b == 1 | epfr15c == 1)
replace epins15 = 0 if (epins15a == 0 & epins15b == 0 & epins15c == 0)

tab epins15

replace epfr15 = 0 if (epfr15a == 0 & epfr15b == 0 & epfr15c == 0)

* is the spouse be covered by the employer-provided insurance?
gen t2 = real(RN049_1A)
drop RN049_1A
rename t2 RN049_1A
gen t2 = real(RN049_1B)
drop RN049_1B
rename t2 RN049_1B
gen t2 = real(RN049_1C)
drop RN049_1C
rename t2 RN049_1C
gen t2 = real(RN049_1D)
drop RN049_1D
rename t2 RN049_1D
gen t2 = real(RN049_1E)
drop RN049_1E
rename t2 RN049_1E
gen t2 = real(RN049_1F)
drop RN049_1F
rename t2 RN049_1F

gen t2 = real(RN049_2A)
drop RN049_2A
rename t2 RN049_2A
gen t2 = real(RN049_2B)
drop RN049_2B
rename t2 RN049_2B
gen t2 = real(RN049_2C)
drop RN049_2C
rename t2 RN049_2C
gen t2 = real(RN049_2D)
drop RN049_2D
rename t2 RN049_2D
gen t2 = real(RN049_3A)
drop RN049_3A
rename t2 RN049_3A
gen t2 = real(RN049_3B)
drop RN049_3B
rename t2 RN049_3B
gen t2 = real(RN049_3C)
drop RN049_3C
rename t2 RN049_3C
gen t2 = real(RN049_3D)
drop RN049_3D
rename t2 RN049_3D

replace epsp15=1 if RN049_1A==991 | RN049_1B==991 | RN049_1C==991 | RN049_1D==991 | RN049_1E==991 | RN049_1F==991
replace epsp15=1 if RN049_2A==991 | RN049_2B==991 | RN049_2C==991 | RN049_2D==991
replace epsp15=1 if RN049_3A==991 | RN049_3B==991 | RN049_3C==991 | RN049_3D==991

replace epsp15=0 if RN049_1A~=991 & RN049_1B~=991 & RN049_1C~=991 & RN049_1D~=991 & RN049_1E~=991 & RN049_1F~=991 & RN049_2A~=991 & RN049_2B~=991 & RN049_2C~=991 & RN049_2D~=991 & RN049_3A~=991 & RN049_3B~=991 & RN049_3C~=991 & RN049_3D~=991

replace epsp15=. if (RN049_1A==999 | RN049_1A == .) & (RN049_1B==999 | RN049_1B==. ) & (RN049_1C==999 | RN049_1C==.) & (RN049_1D==999 | RN049_1D==.) & (RN049_1E==999 | RN049_1E==.) & (RN049_1F==999 | RN049_1F==.) & (RN049_2A==999 | RN049_2A==.) & (RN049_2B==999 | RN049_2B==.) & (RN049_2C==999 | RN049_2C==.) & (RN049_2D==999 | RN049_2D==.) & (RN049_3A==999 | RN049_3A==.) & (RN049_3B==999 | RN049_3B==.) & (RN049_3C==999 | RN049_3C==.) & (RN049_3D==999 | RN049_3D==.)
* re-set value from 0 to missing for "RF" and "INAP" cases

* The following is for re-setting value from missing to 0 for "INAP" cases for ON04_1A-3D
 
replace epsp15=0 if self==1 
* self-employed
replace epsp15=0 if epins15 ~=1 
* no employer-provided insurance 
replace epsp15=0 if RN035_1==1 
* obtain employer-provided insurance from spouse
replace epsp15=0 if RN035_2==1 

* obtain employer-provided insurance from spouse
replace epsp15=0 if RN035_3==1 
* obtain employer-provided insurance from spouse




replace epsp15=0 if RN048_1==5|RN048_1==8
 * No one else is covered by the employer-provided insurance
replace epsp15=0 if RN048_2==5|RN048_2==8
replace epsp15=0 if RN048_3==5|RN048_3==8



* get employer-provided insurance from spouse's firm ( as opposed to own firm)
gen inssp15=.


*replace inssp15=0 if RN023==0|epins15==1|(RN035_1==5 & RN036_1==5)
*replace inssp15=0 if self==1 & RN033_1==1
replace inssp15=0
replace inssp15=. if RN035_1 == 8 | RN036_1 == 8 | RN035_1 == 9 | RN036_1 == 9
replace inssp15 = 1 if RN035_1 == 1 | RN036_1 == 1 
* spouse 
replace inssp15 = 1 if RN035_2 == 1 | RN036_2 == 1 

* spouse  
replace inssp15 = 1 if RN035_3 == 1 | RN036_3 == 1 
* spouse 
replace epins15=1 if inssp15==1

tab epins15

sum inssp*



* does employer provide retiree health insurance
* note: RN60_1 asks about whether those over 65 can keep their employer provided coverage
* think about what to do with this one
replace eprhi15 = 1 if RN059_1 == 1 | RN060_1 == 1
replace eprhi15 = 1 if RN059_2 == 1 | RN060_2 == 1
replace eprhi15 = 1 if RN059_3 == 1 | RN060_3 == 1
replace eprhi15=0 if epins15 == 0 
* no employer-provided insurance
replace eprhi15=0 if inssp15==1 
* obtain employer-provided insurance from spouse
replace eprhi15=0 if eprhi15==. & epins15~=.
summ eprhi15



* Will the insurance cover the spouse after retirement? 
gen eprsp15=.
replace eprsp15=1 if RN062_1==1 | RN063_1==1
replace eprsp15=1 if RN062_2==1 | RN063_2==1
replace eprsp15=1 if RN062_3==1 | RN063_3==1
replace eprsp15=0 if self==1 
* self-employed 
replace eprsp15=0 if epins15==0 
* no employer-provided insurance
replace eprsp15=0 if inssp15==1 
* get employer-provided insurance through spouse
replace eprsp15=0 if eprsp15==. & (RN062_1~=8 |RN062_1~=9 |RN063_1~=8 | RN063_1~=9)

*Note, there are several "checkpoints" in wave 5 for which there are not good analogs for wave 12.  However the same information should be covered in the above checks


*private insurance?
gen inspriv15=0
gen insexch15=0
* buy insurance from insurance exchange
replace insexch15 = 1 if RN037_1 == 5 | RN037_2 == 5 | RN037_3 == 5

replace inspriv15=1 if epins15==0 & inssp15 == 0 
*no employer provided health insurance
replace inspriv15=0 if RN023==0
replace inspriv15=0 if RN001==1 
* Covered by medicare 
replace inspriv15=0 if RN005==1 
* covered by medicaid, covered
replace inspriv15=0 if epins15==1
replace inspriv15=1 if RN037_1 == 1 | RN037_2 == 1 | RN037_3 == 1 | RN037_1 == 4 | RN037_2 == 4 | RN037_3 == 4 | RN037_1 == 5 | RN037_2 == 5 | RN037_3 == 5
replace inspriv15=0 if RN037_1 ~= 1 & RN037_2 ~= 1 & RN037_3 ~= 1 & RN037_1 ~= 4 & RN037_2 ~= 4 & RN037_3 ~= 4 & RN037_1 ~= 5 & RN037_2 ~= 5 & RN037_3 ~= 5 & RN037_1 ~= . & RN037_2 ~= . & RN037_3 ~= .
replace inspriv15=1 if (self==1) & (RN033_1==1|RN033_2==1|RN033_3==1) 
* self-employed
replace inspriv15=0 if (self==0) & (RN033_1==1|RN033_2==1|RN033_3==1) 
* self-employed

sum inspriv15




replace epfr15=0 if epins15==0
replace eprhi15=0 if epins15==0
replace epsp15=0 if epins15==0
replace inssp15=0 if epins15==0
replace eprfr15=0 if epins15==0
keep HHID PN ins* ep* medc* 
sum medc*

sort HHID PN
merge HHID PN using `saved'insure
drop _merge
summ

sort HHID PN
save `saved'insure, replace
sum *14 *15


************************************************ END WAVE 15
}

* compare summary stats before and after
*cd "$folder\hrs\merge\compare\" 
*summtab, contvars(_all) mean median range excel excelname(insure.xlsx) replace
*cd "$folder\hrs\merge\" 
*use `saved'insure.old.dta , clear
*cd "$folder\hrs\merge\compare\" 
*summtab, contvars(_all) mean median range excel excelname(insure.xlsx) sheetname(Old)


drop _all











